$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoRepresentante',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um representante.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaRepresentante',
                popover: {
                    title: 'Tabela Representante',
                    description: 'Aqui estão os dados dos representantes cadastrados.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CADCARACTERISTICA");
    const habilitaCampoMaterial = await CopiaParametro('PEDIDO', 19) == 1;

    componenteFiltro('linha', true)
    componenteFiltro('grupo', true)
    componenteFiltro('etiqueta', true)
    componenteFiltro('faixa', true)

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show')
    })

    $('#btnConsultar').on('click', async function () {
        await buscaDados()
    })

    async function retornaFiltros() {
        const linha = await formataListas($('#txtLinha').val().toString())
        const grupo = await formataListas($('#txtGrupo').val().toString())
        const etiqueta = await formataListas($('#txtEtiqueta').val().toString())
        const faixa = await formataListas($('#txtFaixa').val().toString())

        return {
            linha,
            grupo,
            etiqueta,
            faixa
        }
    }

    async function buscaDados() {
        $('#btnConsultar').prop('disabled', true)
        $.LoadingOverlay('show')
        try {
            const filtros = await retornaFiltros()

            const response = await requisicao('GET', '/sisplan/cadcaracteristica/v1/buscadadosacesso?', `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 600000)

            if (!response) {
                return
            }

            const jsonStr = await response.json()

            criaTabelaDados(jsonStr)
        } catch (e) {
            console.log(e)
            msgErro('Não foi possível buscar os dados.')
        } finally {
            $('#modal-filtros').modal('hide')
            $.LoadingOverlay('hide')
            $('#btnConsultar').prop('disabled', false)
        }
    }

    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" title="Editar" id="btnEditar">Editar</button>     ' +
            '    <button class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    };

    function criaTabelaDados(data) {
        if ($.fn.DataTable.isDataTable('#tabelaDados')) {
            $('#tabelaDados').DataTable().destroy();
            $('#tabelaDados').empty();
        };

        const columns = [
            {
                data: 'ID',
                title: 'Id'
            },
            {
                data: 'ETIQUETA',
                title: 'Etiqueta'
            },
            {
                data: 'DESC_ETIQUETA',
                title: 'Desc. Etiqueta'
            },
            {
                data: 'GRUPO',
                title: 'Grupo'
            },
            {
                data: 'DESC_GRUPO',
                title: 'Desc. Grupo'
            },
            {
                data: 'LINHA',
                title: 'Linha'
            },
            {
                data: 'DESC_LINHA',
                title: 'Desc. Linha'
            },
            {
                data: 'FAIXA',
                title: 'Faixa'
            },
            {
                data: 'DESC_FAIXA',
                title: 'Desc. Faixa'
            },
            {
                data: 'DESCRICAO',
                title: 'Descrição'
            },
            {
                data: 'TEMPO_COST',
                title: 'Tempo Cost.'
            },
            {
                data: 'VALOR_COST',
                title: 'Valor Cost.'
            },
            {
                data: 'VALOR_LINHA',
                title: 'Valor Linha'
            },
            {
                data: 'MARGEM',
                title: 'Margem'
            },
            {
                data: 'CODFIS',
                title: 'Codfis'
            },
            {
                data: 'MARKUP',
                title: 'Markup'
            },
            {
                data: 'DESC_MARKUP',
                title: 'Desc. Markup'
            },
            {
                data: 'VIRADA',
                title: 'Virada'
            },
            {
                data: 'ATIVO',
                title: 'Ativo'
            }
        ];

        if (habilitaCampoMaterial){
            columns.push({data: 'MATERIAL', title: 'Material'})
            columns.push({data: 'DESC_MATERIAL', title: 'Desc. Material'})
        }

        $("#tabelaDados").DataTable({
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            columnDefs: [
                {
                    targets: [0], render: function (data) {
                        return retornaBotaoOpcoes(data);
                    },
                },
                //     {
                //         targets: [6, 7, 8, 9, 10, 12, 13, 14],
                //         render: function (data) {
                //             if (!data) {
                //                 return parseFloat(0).toFixed(4);
                //             }
                //             return parseFloat(data).toFixed(4);
                //         }
                // }
            ],
            autoWidth: true,
            data,
            columns
        }).draw(false);
    }

    $("#tabelaDados").on("click", "#btnEditar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            const data = $("#tabelaDados")
                .DataTable()
                .row($(this).parents("tr"))
                .data()
            const registroLiberado = await liberarRegistro("CADCARACTERISTICA", data.ID)
            if (registroLiberado) {
                window.location.href = `cadcaracteristica/${data.ID}`
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $("#tabelaDados").on("dblclick", "tr", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $("#tabelaDados").DataTable().row($(this)).data();
            let registroLiberado = await liberarRegistro("CADCARACTERISTICA", data.ID)
            if (registroLiberado) {
                window.location.href = `cadcaracteristica/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $("#tabelaDados").on("click", "#btnExcluir", async function () {
        $.LoadingOverlay("show");
        try {
            if (permissaoUsuarioLogado.EXCLUI == "S") {
                const row = $("#tabelaDados").DataTable().row($(this).parents("tr"))
                await excluiCaracteristica(row)
            } else {
                msgAlertaSemConfirmacao("Sem permissão para excluir!");
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $('#btnIncluir').on('click', function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            window.location.href = `cadcaracteristica/create`
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!")
        }
    })

    async function excluiCaracteristica(row) {
        const data = row.data()
        const { ID } = data
        const response = await requisicao("DELETE", `/sisplan/cadcaracteristica/V1/excluiregistro?`, `ID=${ID}`, '', 600000)

        if (!response) {
            return
        }

        const json = await response.json()
        if (response.status != 200) {
            msgErro(json.mensagem)
            return
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            async onHidden() {
                row.remove().draw(false)
            },
        }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        })
    }
});