$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  componenteFiltro(
    'cotacao',
    true,
    true,
    'Numero',
  )

  componenteFiltro(
    'fornecedor',
    true,
    true,
  )

  componenteFiltro(
    'itemCotacao',
    true,
    true,
    'Codigo',
  )

  $('#btnConsultar').on('click', function () {
    consultar()
  })

  function consultar() {
    ItensCotacaoRequisitados.retornarFiltros()
      .then((filtros) => {
        ItensCotacaoRequisitados.criarTabelaItens({ filtros })
      })
    ItensCotacaoRequisitados.idsSelecionados.clear()
  }

  $("#tabelaItens").on('change', '.checkSel', function () {
    const linha = $(this).closest('tr')
    const [data] = $('#tabelaItens').DataTable().rows(linha).data().toArray()
    const { id } = data
    const isChecked = this.checked
    $(linha).toggleClass('selected', isChecked)

    if (!isChecked) {
      ItensCotacaoRequisitados.idsSelecionados.delete(id)
      return
    }

    ItensCotacaoRequisitados.idsSelecionados.add(id)
  })

  consultar()

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ItensCotacaoRequisitados = window.ItensCotacaoRequisitados || {}

ItensCotacaoRequisitados.idsSelecionados = new Set()

ItensCotacaoRequisitados.criarTabelaItens = ({ filtros }) => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'sel',
      title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelAll">
                <label for="cbSelAll"></label>
              </div>
              `,
      render: (_data, _type, _row, { row: rowIndex, col: colIndex }) => (
        `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check_col_${colIndex}_row_${rowIndex}" class="checkSel">
          <label for="check_col_${colIndex}_row_${rowIndex}"></label>
        </div>`
      )
    },
    {
      data: 'numero',
      title: 'Número',
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nome',
      title: 'Nome',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'condicao',
      title: 'Condição',
    },
    {
      data: 'desconto',
      title: 'Desconto',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'frete',
      title: 'Frete',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'icms',
      title: 'Icms',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'quantidadeSolicitacao',
      title: 'Quantidade Solicitação',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'precoSolicitacao',
      title: 'Preço Solicitação',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'dataEntregaSolicitacao',
      title: 'Entrega Solicitação',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true })
      }
    },
    {
      data: 'quantidadeCotada',
      title: 'Quantidade Cotada',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'validade',
      title: 'Validade',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true })
      }
    },
    {
      data: 'situacao',
      title: 'Situação',
    },
    {
      data: 'status',
      title: 'Status',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 23,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/cotacao/v1/retornaritens`,
      type: "POST",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: function (data) {
        const { start, length, draw } = data;
        return JSON.stringify({
          filtros,
          paginacao: {
            quantidadeMaximaRegistros: length,
            quantidadeRegistrosPular: start,
            contadorRequisicoes: draw,
          },
          empresa: getCookie('empresa'),
          status: 'R',
        })
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
    rowCallback: function (row, data) {
      const ids = [...ItensCotacaoRequisitados.idsSelecionados]
      const isChecked = ids?.some(item => item === data.id) ?? false
      $(row).toggleClass('selected', isChecked)
      const checkbox = $(row).find('.checkSel')
      $(checkbox).prop('checked', isChecked)
    },
  })
  ItensCotacaoRequisitados.adicionarEventoSelecionarTodos()
  UtilsCentralCompras.criarContainerBotoes({
    tabela: 'tabelaItens',
  })
  UtilsCentralCompras.habilitarEsconderColunas({
    tabela: 'tabelaItens',
    tela: 'itensCotacaoRequisitados',
  })
  UtilsCentralCompras.habilitarExportarCsv({
    tabela: 'tabelaItens',
    status: 'R',
    tipo: 'COT',
    retornarFiltros: ItensCotacaoRequisitados.retornarFiltros,
  })
}

ItensCotacaoRequisitados.adicionarEventoSelecionarTodos = () => {
  $('#cbSelAll').off('change')
  $('#cbSelAll').on('change', async function () {
    const isChecked = this.checked
    const table = $('#tabelaItens').DataTable()
    if (!isChecked) {
      ItensCotacaoRequisitados.idsSelecionados.clear()
      table.draw(false)
      return
    }

    const filtros = await ItensCotacaoRequisitados.retornarFiltros()

    $.LoadingOverlay('show')
    requisicao(
      'POST',
      `/sisplan/centralcompras/cotacao/v1/retornardadosselecionartodos?`,
      '',
      JSON.stringify({ filtros, status: 'R' }),
      3600000
    ).then(async (response) => {
      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }
        if (!resultado)
          throw new Error('Ids não foram buscados corretamente do back-end.')

        const { ids } = resultado
        ids?.forEach((id) => ItensCotacaoRequisitados.idsSelecionados.add(id))
      }
      table.draw(false)
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao selecionar todos os itens.')
    }).finally(() => $.LoadingOverlay('hide'))
  })
}

ItensCotacaoRequisitados.retornarFiltros = async function () {
  const numero = await formataListas($('#txtNumero').val().toString())
  const fornecedor = await formataListas($('#txtFornecedor').val().toString())
  const codigo = await formataListas($('#txtCodigo').val().toString())

  return {
    numero,
    fornecedor,
    codigo,
  }
}