$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  $('#tabelaItens').on('click', '#btnInformacoesItem', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const { codigo, cor, tamanho, tipoItem } = datatableItens?.row($(this)?.parents('tr'))?.data()
    ModalInformacoesItemCentralCompras.carregarModalInformacoesItem(codigo, cor, tamanho, tipoItem)
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    const { codigo, cor, tamanho, tipoItem } = $('#tabelaItens').DataTable().row($(this)).data()
    ModalInformacoesItemCentralCompras.carregarModalInformacoesItem(codigo, cor, tamanho, tipoItem)
  })

  $("#tabelaItens").on('change', '.checkSel', function () {
    const linha = $(this).closest('tr')
    const [data] = $('#tabelaItens').DataTable().rows(linha).data().toArray()
    const { id } = data
    const isChecked = this.checked
    $(linha).toggleClass('selected', isChecked)


    if (!isChecked) {
      ItensSolicitacaoBloqueados.idsSelecionados.delete(id)
      return
    }

    ItensSolicitacaoBloqueados.idsSelecionados.add(id)
  })

  ItensSolicitacaoBloqueados.criarTabelaItens()

  $('#btnRetornar').on('click', () => {
    const idsSelecionados = [...ItensSolicitacaoBloqueados.idsSelecionados]
    if (!idsSelecionados || idsSelecionados.length === 0) return msgErro('Nenhum registro selecionado.')

    retornar({ idsSelecionados })
  })

  const retornar = async ({ idsSelecionados }) => {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao('PUT', `/sisplan/centralcompras/solicitacao/v1/retornar?`, '', JSON.stringify({ ids: idsSelecionados }), 3600000)

      const dados = await response.json()
      if (dados) {
        const { mensagem, resultado } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            ItensSolicitacaoBloqueados.idsSelecionados.clear()
            ItensSolicitacaoBloqueados.criarTabelaItens()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao retornar os itens selecionados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnLiberar').on('click', () => {
    const idsSelecionados = [...ItensSolicitacaoBloqueados.idsSelecionados]
    if (!idsSelecionados || idsSelecionados.length === 0) return msgErro('Nenhum registro selecionado.')
    liberar({ idsSelecionados })
  })

  const liberar = async ({ idsSelecionados }) => {
    try {
      $.LoadingOverlay('show')
      const idUsuario = getCookie('id_usuario')

      const body = {
        ids: idsSelecionados,
        idUsuario: idUsuario,
      }

      const response = await requisicao('PUT', `/sisplan/centralcompras/solicitacao/v1/liberar?`, '', JSON.stringify(body), 3600000)
      const dados = await response.json()
      if (dados) {
        const { mensagem, resultado } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (!resultado) {
          throw new Error('Dados retornados são inválidos.')
          return
        }
        if (resultado.itensParcialmenteAprovados && resultado.itensParcialmenteAprovados.length > 0) {
          ModalItensParcialmenteAprovados.carregarModal({ itens: resultado.itensParcialmenteAprovados })
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            ItensSolicitacaoBloqueados.idsSelecionados.clear()
            ItensSolicitacaoBloqueados.criarTabelaItens()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao liberar os itens selecionados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ItensSolicitacaoBloqueados = window.ItensSolicitacaoBloqueados || {}

ItensSolicitacaoBloqueados.idsSelecionados = new Set()

ItensSolicitacaoBloqueados.criarTabelaItens = () => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'sel',
      title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelAll">
                <label for="cbSelAll"></label>
              </div>
              `,
      render: (_data, _type, _row, { row: rowIndex, col: colIndex }) => (
        `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check_col_${colIndex}_row_${rowIndex}" class="checkSel">
          <label for="check_col_${colIndex}_row_${rowIndex}"></label>
        </div>`
      )
    },
    {
      data: 'numero',
      title: 'Número',
      render: (data) => (
        '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Informações Item" id="btnInformacoesItem">Informações Item</button>     ' +
        '</div>'
      )
    },
    {
      data: 'dataCadastro',
      title: 'Cadastro',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'dataEmissao',
      title: 'Emissão',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'dataEntrega',
      title: 'Entrega',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'dataBaixa',
      title: 'Baixa',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'solicitante',
      title: 'Solicitante',
    },
    {
      data: 'descricaoSolicitante',
      title: 'Descrição Solicitante',
    },
    {
      data: 'codigoCliente',
      title: 'Código Cliente',
    },
    {
      data: 'nomeCliente',
      title: 'Nome Cliente',
    },
    {
      data: 'prazo',
      title: 'Prazo',
      visible: false,
    },
    {
      data: 'descricaoPrazo',
      title: 'Descrição Prazo',
      visible: false,
    },
    {
      data: 'colecao',
      title: 'Coleção',
      visible: false,
    },
    {
      data: 'descricaoColecao',
      title: 'Descrição Coleção',
      visible: false,
    },
    {
      data: 'motivo',
      title: 'Motivo',
      visible: false,
    },
    {
      data: 'descricaoMotivo',
      title: 'Descrição Motivo',
      visible: false,
    },
    {
      data: 'tipo',
      title: 'Tipo',
    },
    {
      data: 'descricaoTipo',
      title: 'Descrição Tipo',
    },
    {
      data: 'tabelaPreco',
      title: 'Tabela de Preço',
      visible: false,
    },
    {
      data: 'descricaoTabelaPreco',
      title: 'Descrição Tabela Preço',
      visible: false,
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'ordem',
      title: 'Ordem',
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
      visible: false,
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
      visible: false,
    },
    {
      data: 'ordemCompra',
      title: 'O.C.',
    },
    {
      data: 'fornecedorOrdemCompra',
      title: 'Descrição O.C.',
      visible: false,
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
      visible: false,
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
      visible: false,
    },
    {
      data: 'especificacao',
      title: 'Especificação',
      visible: false,
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'status',
      title: 'Situação',
    },
    {
      data: 'observacao',
      title: 'Observação',
      visible: false,
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 18,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/solicitacao/v1/itensbloqueados`,
      type: "GET",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: {
        EMPRESA: getCookie('empresa'),
        ID_USUARIO: getCookie('id_usuario'),
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
    rowCallback: function (row, data) {
      const ids = [...ItensSolicitacaoBloqueados.idsSelecionados]
      const isChecked = ids?.some(item => item === data.id) ?? false
      $(row).toggleClass('selected', isChecked)
      const checkbox = $(row).find('.checkSel')
      $(checkbox).prop('checked', isChecked)
    }
  })
  ItensSolicitacaoBloqueados.adicionarEventoSelecionarTodos()
  UtilsCentralCompras.criarContainerBotoes({
    tabela: 'tabelaItens',
  })
  UtilsCentralCompras.habilitarEsconderColunasItensSolicitacao({
    tabela: 'tabelaItens',
    tela: 'itensSolicitacaoBloqueados',
  })
  UtilsCentralCompras.habilitarExportarCsv({
    tabela: 'tabelaItens',
    status: 'B',
    tipo: 'SOL',
  })
}

ItensSolicitacaoBloqueados.adicionarEventoSelecionarTodos = () => {
  $('#cbSelAll').off('change')
  $('#cbSelAll').on('change', function () {
    const isChecked = this.checked
    const table = $('#tabelaItens').DataTable()
    if (table.rows().count() === 0) {
      msgErro('Nenhum item a ser selecionado.')
      $(this).prop('checked', false)
      return
    }
    if (!isChecked) {
      ItensSolicitacaoBloqueados.idsSelecionados.clear()
      table.draw(false)
      return
    }

    $.LoadingOverlay('show')
    requisicao(
      'GET',
      `/sisplan/centralcompras/solicitacao/v1/selecionartodositensbloqueados?`,
      `ID_USUARIO=${getCookie('id_usuario')}`,
      '',
      3600000
    ).then(async (response) => {
      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }
        if (!resultado)
          throw new Error('Ids não foram buscados corretamente do back-end.')

        if (!resultado.ids)
          throw new Error('Nenhum id foi encontrado.')

        const { ids } = resultado
        ids.forEach((id) => ItensSolicitacaoBloqueados.idsSelecionados.add(id))
      }
      table.draw(false)
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao selecionar todos os itens.')
    }).finally(() => $.LoadingOverlay('hide'))
  })
}