window.UtilsCentralCompras = window.UtilsCentralCompras || {}

UtilsCentralCompras.criarContainerBotoes = ({ tabela }) => {
  $(`#${tabela}_wrapper`).prepend(
    `<div id="containerBotoesDatatable_${tabela}" class="flex mt-2" />`
  )
}

UtilsCentralCompras.habilitarExportarCsv = ({ tabela, status, tipo, retornarFiltros }) => {
  $(`#containerBotoesDatatable_${tabela}`).prepend(
    '<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>'
  )

  $('#buttonExcel').prop('title', 'Exportar CSV')
  $('#buttonExcel').on('click', async function () {
    const colunas = []
    $(`#${tabela}`).DataTable().columns().every(function () {
      const columnName = this.dataSrc()
      colunas.push({
        data: columnName,
        title: $(this.header()).text(),
        visible: columnName === 'sel' ? false : this.visible(),
      })
    })
    UtilsCentralCompras.exportarCsv({ status, colunas, tipo, retornarFiltros })
  })
}

UtilsCentralCompras.habilitarEsconderColunasItensSolicitacao = ({ tabela, tela }) => {
  $(`#containerBotoesDatatable_${tabela}`).prepend(
    '<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>'
  )

  $('#buttonColVis').off('click')
  $('#buttonColVis').on('click', function () {
    $('#modal-ColunasVisiveis').modal('show')
  })

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (!colunas || !colunas[`${tela}CentralCompras`]) {
    colunas = { ...colunas }
    colunas[`${tela}CentralCompras`] = []
    localStorage.setItem(
      'colunasInvisiveisRelatorios',
      JSON.stringify(colunas)
    )
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $(`#${tabela}`)
    .DataTable()
    .columns()
    .every(function () {
      if (
        colunas[`${tela}CentralCompras`]?.indexOf(this.dataSrc()) != -1
      ) {
        this.visible(false)
      }
    })

  $('#btnConfirmarColunas').off('click')
  $('#btnConfirmarColunas').on('click', function () {
    try {
      const novasColunas = [...retornaNovasColunasInvisiveis(), ...[
        'descricaoTamanho',
        'fornecedorOrdemCompra',
        'id',
        'prazo',
        'descricaoPrazo',
        'colecao',
        'descricaoColecao',
        'motivo',
        'descricaoMotivo',
        'tabelaPreco',
        'descricaoTabelaPreco',
        'deposito',
        'descricaoDeposito',
        'contaContabil',
        'descricaoContaContabil',
        'especificacao',
        'observacao',
      ]]
      colunas[`${tela}CentralCompras`] = novasColunas

      localStorage.setItem(
        'colunasInvisiveisRelatorios',
        JSON.stringify(colunas)
      )

      $(`#${tabela}`).DataTable().columns().visible(true)

      $(`#${tabela}`)
        .DataTable()
        .columns()
        .every(function () {
          if (novasColunas.indexOf(this.dataSrc()) !== -1) {
            this.visible(false)
          }
        })
    } finally {
      $('#modal-ColunasVisiveis').modal('hide')
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = []

    let colunasInvisiveis = JSON.parse(
      localStorage.getItem('colunasInvisiveisRelatorios')
    )

    $(`#${tabela}`)
      .DataTable()
      .columns()
      .every(function () {
        if ([
          'sel',
          'descricaoTamanho',
          'fornecedorOrdemCompra',
          'id',
          'prazo',
          'descricaoPrazo',
          'colecao',
          'descricaoColecao',
          'motivo',
          'descricaoMotivo',
          'tabelaPreco',
          'descricaoTabelaPreco',
          'deposito',
          'descricaoDeposito',
          'contaContabil',
          'descricaoContaContabil',
          'especificacao',
          'observacao',
        ].includes(this.dataSrc())) return
        cols.push({
          title: $(this.header()).text(),
          data: this.dataSrc(),
        })
      })
    adicionaColunas(cols, colunasInvisiveis[`${tela}CentralCompras`] ?? [])
  })
}

UtilsCentralCompras.habilitarEsconderColunas = ({ tabela, tela }) => {
  $(`#containerBotoesDatatable_${tabela}`).prepend(
    '<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>'
  )

  $('#buttonColVis').off('click')
  $('#buttonColVis').on('click', function () {
    $('#modal-ColunasVisiveis').modal('show')
  })

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (!colunas || !colunas[`${tela}CentralCompras`]) {
    colunas = { ...colunas }
    colunas[`${tela}CentralCompras`] = []
    localStorage.setItem(
      'colunasInvisiveisRelatorios',
      JSON.stringify(colunas)
    )
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $(`#${tabela}`)
    .DataTable()
    .columns()
    .every(function () {
      if (
        colunas[`${tela}CentralCompras`]?.indexOf(this.dataSrc()) != -1
      ) {
        this.visible(false)
      }
    })

  $('#btnConfirmarColunas').off('click')
  $('#btnConfirmarColunas').on('click', function () {
    try {
      const novasColunas = retornaNovasColunasInvisiveis()
      colunas[`${tela}CentralCompras`] = novasColunas

      localStorage.setItem(
        'colunasInvisiveisRelatorios',
        JSON.stringify(colunas)
      )

      $(`#${tabela}`).DataTable().columns().visible(true)

      $(`#${tabela}`)
        .DataTable()
        .columns()
        .every(function () {
          if (novasColunas.indexOf(this.dataSrc()) !== -1) {
            this.visible(false)
          }
        })
    } finally {
      $('#modal-ColunasVisiveis').modal('hide')
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = []

    let colunasInvisiveis = JSON.parse(
      localStorage.getItem('colunasInvisiveisRelatorios')
    )

    $(`#${tabela}`)
      .DataTable()
      .columns()
      .every(function () {
        if (['sel', 'descricaoTamanho', 'fornecedorOrdemCompra', 'id'].includes(this.dataSrc())) return
        cols.push({
          title: $(this.header()).text(),
          data: this.dataSrc(),
        })
      })
    adicionaColunas(cols, colunasInvisiveis[`${tela}CentralCompras`] ?? [])
  })
}

UtilsCentralCompras.retornarDadosExportarItensSolicitacao = async ({ status, retornarFiltros }) => {
  const filtros = await retornarFiltros?.() ?? {}
  const response = await requisicao('POST', `/sisplan/centralcompras/solicitacao/v1/exportacao?`, `STATUS=${status}&ID_USUARIO=${getCookie('id_usuario')}`, JSON.stringify({ filtros }), 3600000)
  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }
    if (!resultado) {
      return { itens: [] }
    }
    return resultado
  }
}

UtilsCentralCompras.retornarDadosExportarItensCompra = async ({ status }) => {
  const response = await requisicao('GET', `/sisplan/centralcompras/compra/v1/retornardadosexportacao?`, `STATUS=${status}`, '', 3600000)
  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }
    if (!resultado) {
      return { itens: [] }
    }
    return resultado
  }
}

UtilsCentralCompras.retornarDadosExportarItensCotacao = async ({ status, retornarFiltros }) => {
  const filtros = await retornarFiltros?.() ?? {}
  const response = await requisicao('POST', `/sisplan/centralcompras/cotacao/v1/exportacao?`, '', JSON.stringify({ filtros, status }), 3600000)
  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }
    if (!resultado) {
      return { itens: [] }
    }
    return resultado
  }
}

UtilsCentralCompras.retornarDadosExportacao = async ({ status, tipo, retornarFiltros }) => {
  if (tipo === 'SOL') {
    const { itens } = await UtilsCentralCompras.retornarDadosExportarItensSolicitacao({ status, retornarFiltros })
    let nomeArquivo = ''
    switch (status) {
      case 'D':
        nomeArquivo = 'Digitados - Solicitação'
        break
      case 'B':
        nomeArquivo = 'Bloqueados - Solicitação'
        break
      case 'R':
        nomeArquivo = 'Retornados - Solicitação'
        break
      case 'L':
        nomeArquivo = 'Liberados - Solicitação'
        break
      case 'C':
        nomeArquivo = 'Cotados - Solicitação'
        break
      default:
        break
    }
    return {
      itens,
      nomeArquivo,
    }
  }

  if (tipo === 'COM') {
    const { itens } = await UtilsCentralCompras.retornarDadosExportarItensCompra({ status })
    let nomeArquivo = ''
    switch (status) {
      case 'D':
        nomeArquivo = 'Digitados - Compra'
        break
      case 'B':
        nomeArquivo = 'Bloqueados - Compra'
        break
      case 'R':
        nomeArquivo = 'Retornados - Compra'
        break
      case 'L':
        nomeArquivo = 'Liberados - Compra'
        break
      case 'E':
        nomeArquivo = 'Enviados - Compra'
        break
      case 'A':
        nomeArquivo = 'Aceitos - Compra'
        break
      case 'N':
        nomeArquivo = 'Rejeitados - Compra'
        break
      default:
        break
    }
    return {
      itens,
      nomeArquivo,
    }
  }

  if (tipo === 'COT') {
    const { itens } = await UtilsCentralCompras.retornarDadosExportarItensCotacao({ status, retornarFiltros })
    let nomeArquivo = ''
    switch (status) {
      case 'R':
        nomeArquivo = 'Requisitados - Cotação'
        break
      case 'N':
        nomeArquivo = 'Negociados - Cotação'
        break
      case 'E':
        nomeArquivo = 'Encerrados - Cotação'
        break
      case 'C':
        nomeArquivo = 'Cancelados - Cotação'
        break
      default:
        break
    }
    return {
      itens,
      nomeArquivo,
    }
  }
}

UtilsCentralCompras.exportarCsv = async ({ status, colunas, tipo, retornarFiltros }) => {
  $.LoadingOverlay('show')
  try {
    const { itens: dados, nomeArquivo } = await UtilsCentralCompras.retornarDadosExportacao({ status, tipo, retornarFiltros })

    if (!dados || dados.length === 0) {
      msgErro('Nenhum dado a ser exportado.')
      return
    }

    const colunasInvisiveis = []
    const colunasVisiveis = []
    colunas.forEach((coluna) => {
      if (coluna.visible) {
        colunasVisiveis.push(coluna.title)
        return
      }
      colunasInvisiveis.push(coluna.data)
      return
    })
    const dadosSemColunasInvisiveis = dados?.map((item) => {
      return colunasInvisiveis.reduce((acc, prop) => {
        const { [prop]: removed, ...rest } = acc
        return rest
      }, item)
    })

    let dadosExportar = []
    dadosExportar.push(colunasVisiveis.join(';'))
    dadosSemColunasInvisiveis?.forEach(
      (item) => dadosExportar.push(
        Object.values(item)
          .map((value) => typeof value !== 'string' ? value : value.replaceAll(',', '').replaceAll(';', '').replaceAll('\r', '').replaceAll('\n', ''))
          .join(';')
      )
    )

    dadosExportar = dadosExportar.join('\n')

    const arquivoCsv = new Blob(
      ["\ufeff" + dadosExportar],
      {
        type: "text/csv;charset=utf-8"
      }
    )

    const downloadLink = document.createElement('a')
    downloadLink.download = `Itens${nomeArquivo ? ' ' + nomeArquivo : ''}.csv`
    downloadLink.href = window.URL.createObjectURL(arquivoCsv)

    downloadLink.style.display = "none"

    document.body.appendChild(downloadLink)

    downloadLink.click()
    document.body.removeChild(downloadLink)
  } catch (error) {
    console.error(error)
    msgErro('Ocorreu um erro ao realizar a exportação.')
  } finally {
    $.LoadingOverlay('hide')
  }
}