$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#divTipoItem',
                popover: {
                    title: 'Tipo do Item',
                    description: 'Aqui será informado o tipo do item que será cadastrado.',
                    position: 'right'
                }
            },
            {
                element: '#divDadosGerais',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro.',
                    position: 'top'
                }
            },
            {
                element: '#btnConsultar',
                popover: {
                    title: 'Consulta',
                    description: 'Aqui consultamos por um fornecedor e material ou produto na tabela de Cadastro de cor tinturaria.',
                    position: 'left'
                }
            },
            {
                element: '#btnConfirmar',
                popover: {
                    title: 'Setar Valor',
                    description: 'Ao clicar, setamos o preço para todos os registro da tabela.',
                    position: 'left'
                }
            },
            {
                element: '#tutorialTabela',
                popover: {
                    title: 'Opções Excluir',
                    description: 'Neste botão, podemos excluir o registro.',
                    position: 'top'
                }
            },
            {
                element: '#btnVoltar',
                popover: {
                    title: 'Botão Voltar',
                    description: 'Clique aqui para voltar para a tela de consulta.',
                    position: 'left'
                }
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar os registros.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});


$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CORCOMPRA");
    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let corcompra = parametros[parametros.length - 1];

    let codigoFornecedor;
    let codigoMaterialProduto;

    let iniciarPesquisa = false;

    if (corcompra && corcompra !== 'create') {

        iniciarPesquisa = true;
        const resultadoStatus = corcompra.split('&');
        codigoFornecedor = resultadoStatus[0];
        nomeForncedor = await buscaValor("ENTIDADE", "NOME", "CODCLI", `${codigoFornecedor}`);
        codigoMaterialProduto = resultadoStatus[1];
        nomeMaterial = await buscaValor("MATERIAL", "DESCRICAO", "CODIGO", `${codigoMaterialProduto}`);
        nomeProduto = await buscaValor("PRODUTO", "DESCRICAO", "CODIGO", `${codigoMaterialProduto}`);
        tipoItem = await buscaValor("CADCORTI", "TP_ITEM", "CODIGO", `${codigoMaterialProduto}`);
        insereValor('#txtFornecedor', codigoFornecedor, nomeForncedor.NOME)

        if (tipoItem.TP_ITEM === 'P') {
            $('#rdProduto').prop('checked', true);
            $('#divMaterial').addClass('d-none');
            $('#divProduto').removeClass('d-none');
            insereValor('#txtProduto', codigoMaterialProduto, nomeProduto.DESCRICAO);
        } else {
            insereValor('#txtMaterial', codigoMaterialProduto, nomeMaterial.DESCRICAO);
        }

        $('#txtFornecedor, #txtProduto, #txtMaterial, #btnFornecedor, #btnLimpaFornecedor, #btnMaterial, #btnLimpaMaterial, #btnProduto, #btnLimpaProduto, #rdMaterial, #rdProduto, #btnConsultar').prop('disabled', true);
    }

    if (iniciarPesquisa) {
        await buscarCadCorti();
    }

    $('#txtFornecedor').autocompleta(2, 'JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO" ], "where": null}');
    $('#txtProduto').autocompleta(2, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtMaterial').autocompleta(2, 'JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');

    $('#btnFornecedor').pesquisa_serverside(['#txtFornecedor'], ['CODCLI'], ['NOME'], `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ"], "where": null}`, 'Pesquisa de Fornecedor');
    $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Produto');
    $('#btnMaterial').pesquisa_serverside(['#txtMaterial'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Material');

    $('#btnLimpaFornecedor').on('click', () => { $('#txtFornecedor').val('') })
    $('#btnLimpaProduto').on('click', () => { $('#txtProduto').val('') })
    $('#btnLimpaMaterial').on('click', () => { $('#txtMaterial').val('') })

    $(function () {
        $('#txtValor').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        })
    })

    $(function () {
        $('.txtValor').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        })
    })

    function aplicarMascara() {
        $('.inputTipoInteiro').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 0,
        })

        $('.inputTipoFloat').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        })
    }
    aplicarMascara();

    $('#rdProduto, #rdMaterial').on('change', function () {
        $('#txtMaterial').val('');
        $('#txtProduto').val('');
        if ($(this).attr('id') === 'rdProduto') {
            $('#divMaterial').addClass('d-none');
            $('#divProduto').removeClass('d-none');
        } else {
            $('#divMaterial').removeClass('d-none');
            $('#divProduto').addClass('d-none');
        }
    });

    async function buscarCadCorti() {
        codigoFornecedor = pegaChave('#txtFornecedor')
        if ($('#rdMaterial').is(':checked')) {
            codigoMaterialProduto = pegaChave('#txtMaterial')
        } else {
            codigoMaterialProduto = pegaChave('#txtProduto')
        }

        try {
            $.LoadingOverlay("show");
            let response;
            try {
                response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={
                    "tabela": "CADCORTI",
                    "camposSelect": [
                        "CADCORTI.CODCLI AS FORNECEDOR",
                        "CLIENTE.NOME",
                        "CADCORTI.CODIGO",
                        "CASE WHEN MATERIAL.DESCRICAO IS NULL THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END AS DESCRICAO",
                        "CADCORTI.COR",
                        "CADCOR.DESCRICAO AS DESC_COR",
                        "CASE WHEN PRODUTO.UNIDADE IS NULL THEN MATERIAL.UNIDADE ELSE MATERIAL.UNIDADE END AS UNIDADE",
                        "CASE WHEN PRODUTO.UNI_VENDA IS NULL THEN MATERIAL.UNI_COM ELSE MATERIAL.UNI_COM END AS UNI_COM",
                        "CADCORTI.COD_ENTRADA AS COD_FORNECEDOR",
                        "CADCORTI.COR1 AS COR_FORNECEDOR",
                        "CADCORTI.DIAS",
                        "CADCORTI.DIAS_PREPARACAO",
                        "CADCORTI.DT_ATUALIZA",
                        "CADCORTI.PRECO",
                        "CADCORTI.PERC_IPI",
                        "CADCORTI.QTDE_MIN",
                        "CADCORTI.QTDE_MAX",
                        "CADCORTI.PERC_FRETE",
                        "CADCORTI.PERC_DIF_ICMS",
                        "CADCORTI.PERC_ST_ICMS",
                        "CADCORTI.PERC_OUTROS",
                        "CADCOR.PANTONE",
                        "CASE WHEN PRODUTO.CODIGO2 IS NULL THEN MATERIAL.CODIGO2 ELSE MATERIAL.CODIGO2 END AS CODIGO2",
                        "CADCOR.CODIGO2 COR2"
                    ],
                    "innerJoin": [
                        {
                            "tabela": "ENTIDADE",
                            "alias": "CLIENTE",
                            "condicao": "CLIENTE.CODCLI = CADCORTI.CODCLI"
                        }
                    ],
                    "leftJoin": [
                        {
                            "tabela": "CADCOR",
                            "condicao": "CADCOR.COR = CADCORTI.COR"
                        },
                        {
                            "tabela": "MATERIAL",
                            "condicao": "MATERIAL.CODIGO = CADCORTI.CODIGO"
                        },
                        {
                            "tabela": "PRODUTO",
                            "condicao": "PRODUTO.CODIGO = CADCORTI.CODIGO"
                        }
                    ],
                    "where": ["CADCORTI.TIPO = 'C'", "CADCORTI.CODCLI = '${codigoFornecedor}'", "CADCORTI.CODIGO = '${codigoMaterialProduto}'"]
                }`, null);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();

                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                const dataCols = [
                    {
                        title: "Cor",
                        data: "COR",
                        render: (data) => {
                            return retornaBotaoOpcoes(data);
                        }
                    },
                    {
                        title: "Desc. Cor",
                        data: "DESC_COR",
                    },
                    {
                        title: "Fornecedor",
                        data: "FORNECEDOR",
                    },
                    {
                        title: "Nome",
                        data: "NOME",
                    },
                    {
                        title: "Código",
                        data: "CODIGO",
                    },
                    {
                        title: "Descrição",
                        data: "DESCRICAO",
                    },
                    {
                        title: "Unidade",
                        data: "UNIDADE",
                    },
                    {
                        title: "Unidade Compra",
                        data: "UNI_COM",
                    },
                    {
                        title: "Código Fornecedor",
                        data: "COD_FORNECEDOR",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtCodigoFornecedor_${meta.row}" class="input-default focus form-control" style="min-width: 15ch; max-width: 20ch" value="${data}" placeholder="Fornecedor">`
                        )
                    },
                    {
                        title: "Cor Fornecedor",
                        data: "COR_FORNECEDOR",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtCorFornecedor_${meta.row}" class="input-default focus form-control" style="min-width: 15ch; max-width: 20ch" value="${data}" placeholder="Cor">`
                        )
                    },
                    {
                        title: "Dias",
                        data: "DIAS",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtDias_${meta.row}" class="input-default focus form-control inputTipoInteiro text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0" maxlength="6">`
                        )
                    },
                    {
                        title: "Dias Preparação",
                        data: "DIAS_PREPARACAO",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtDiasPreparacao_${meta.row}" class="input-default focus form-control inputTipoInteiro text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0" maxlength="6">`
                        )
                    },
                    {
                        title: "Data Atualiza",
                        data: "DT_ATUALIZA",
                        render: (data, _type, _row, meta) => (
                            `<input type="date" id="txtDataAtualiza_${meta.row}" class="input-default focus form-control" style="min-width: 15ch; max-width: 20ch" value="${data.split(' ')[0] ?? formataData(new Date())}">`
                        )
                    },
                    {
                        title: "Preço",
                        data: "PRECO",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtPreco_${meta.row}" class="input-default focus form-control campoValor inputTipoFloat text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0.00" maxlength="8">`
                        )
                    },
                    {
                        title: "Perc. IPI",
                        data: "PERC_IPI",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtPercIpi_${meta.row}" class="input-default focus form-control inputTipoFloat text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0.00" maxlength="6">`
                        )
                    },
                    {
                        title: "Quantidade Mínima",
                        data: "QTDE_MIN",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtQuantidadeMinima_${meta.row}" class="input-default focus form-control inputTipoFloat text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0.00" maxlength="8">`
                        )
                    },
                    {
                        title: "Quantidade Máxima",
                        data: "QTDE_MAX",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtQuantidadeMaxima_${meta.row}" class="input-default focus form-control inputTipoFloat text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0.00" maxlength="8">`
                        )
                    },
                    {
                        title: "Perc. Frete",
                        data: "PERC_FRETE",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtPercFrete_${meta.row}" class="input-default focus form-control inputTipoFloat text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0.00" maxlength="6">`
                        )
                    },
                    {
                        title: "Perc. Dif. Icms",
                        data: "PERC_DIF_ICMS",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtPercDifIcms_${meta.row}" class="input-default focus form-control inputTipoFloat text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0.00" maxlength="6">`
                        )
                    },
                    {
                        title: "Perc. ST Icms",
                        data: "PERC_ST_ICMS",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtPercStIcms_${meta.row}" class="input-default focus form-control inputTipoFloat text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0.00" maxlength="6">`
                        )
                    },
                    {
                        title: "Perc. Outros",
                        data: "PERC_OUTROS",
                        render: (data, _type, _row, meta) => (
                            `<input type="text" id="txtPercOutros_${meta.row}" class="input-default focus form-control inputTipoFloat text-right" style="min-width: 15ch; max-width: 20ch" value="${data ?? 0}" placeholder="0.00" maxlength="6">`
                        )
                    },
                    {
                        title: "Pantone",
                        data: "PANTONE",
                    },
                    {
                        title: "Código 2",
                        data: "CODIGO2",
                    },
                    {
                        title: "Cor 2",
                        data: "COR2",
                    },
                ]

                $("#tabelaCorCompra").DataTable({
                    destroy: true,
                    sort: false,
                    serverside: true,
                    filter: false,
                    ordering: false,
                    searching: false,
                    paging: true,
                    autoWidth: true,
                    data: jsonStr.RESULT[0],
                    columns: dataCols,
                    scrollX: true,
                });

                await buscaCORMATI_ITEN();
                aplicarMascara();

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados.`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }


    // Aplica os estulos na tabela ao mudar de página
    $('#tabelaCorCompra').on('draw.dt', function () {
        aplicarMascara();
        $('#tabelaCorCompra tbody tr.novaLinha').css('background-color', 'var(--corLinha)');
        $('#tabelaCorCompra tbody tr.novaLinha .botaoDesabilitado').prop('disabled', true);
    });

    async function buscaCORMATI_ITEN() {
        nomeForncedor = { NOME: pegaDescricao('#txtFornecedor') };
        nomeProduto = { DESCRICAO: pegaDescricao('#txtProduto') };
        nomeMaterial = { DESCRICAO: pegaDescricao('#txtMaterial') };

        $.LoadingOverlay("show");
        let responseCADCORTI;
        let tabela;

        if ($('#rdProduto').is(':checked')) {
            tabela = 'PA_ITEN';
        } else {
            tabela = 'MAT_ITEN';
        }

        try {
            responseCADCORTI = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={
                "tabela": "${tabela}",
                "camposSelect": [
                    "DISTINCT ${tabela}.COR",
                    "CADCOR.DESCRICAO",
                    "CADCOR.CODIGO2 COR2",
                    "CADCOR.PANTONE"
                ],
                "innerJoin": [{
                    "tabela": "CADCOR",
                    "condicao": "CADCOR.COR = ${tabela}.COR"
                }],
                "where": ["${tabela}.CODIGO = '${codigoMaterialProduto}'"]
            }`, null);

            if (!responseCADCORTI) {
                return;
            }

            let jsonStr = await responseCADCORTI.json();

            if (responseCADCORTI.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let coresSemCadCorTi = [];

            if (jsonStr.RESULT[0].length > 0) {
                for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
                    let cor = jsonStr.RESULT[0][i].COR;
                    const cor2 = jsonStr.RESULT[0][i]?.COR2
                    const pantone = jsonStr.RESULT[0][i]?.PANTONE

                    responseCADCORTI = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={
                      "tabela": "CADCORTI",
                      "camposSelect": [
                        "COR",
                        "CODCLI",
                        "CODIGO",
                        "TIPO"
                      ],
                      "where": ["COR= '${cor}'", "CODCLI = '${codigoFornecedor}'", "CODIGO = '${codigoMaterialProduto}'", "TIPO = 'C'"]
                    }`);

                    let jsonCADCORTI = await responseCADCORTI.json();

                    if (jsonCADCORTI.RESULT[0].length === 0) {
                        coresSemCadCorTi.push({ COR: cor, cor2, pantone });
                    }
                }
            }

            async function DESC_COR(cor) {
                return await buscaValor("CADCOR", "DESCRICAO", "COR", `${cor}`);
            }

            async function CODIGO2() {
                if ($('#rdMaterial').is(':checked')) {
                    return await buscaValor("MATERIAL", "CODIGO2", "CODIGO", codigoMaterialProduto);
                } else {
                    return await buscaValor("PRODUTO", "CODIGO2", "CODIGO", codigoMaterialProduto);
                }
            }

            async function UNIDADE() {
                if ($('#rdMaterial').is(':checked')) {
                    return await buscaValor("MATERIAL", "UNIDADE", "CODIGO", codigoMaterialProduto);
                } else {
                    return await buscaValor("PRODUTO", "UNIDADE", "CODIGO", codigoMaterialProduto);
                }
            }

            async function UNI_COM() {
                if ($('#rdMaterial').is(':checked')) {
                    return await buscaValor("MATERIAL", "UNI_COM", "CODIGO", codigoMaterialProduto);
                } else {
                    return await buscaValor("PRODUTO", "UNI_VENDA", "CODIGO", codigoMaterialProduto);
                }
            }

            for (let i = 0; i < coresSemCadCorTi.length; i++) {
                let newData = {
                    COR: coresSemCadCorTi[i].COR,
                    DESC_COR: (await DESC_COR(coresSemCadCorTi[i].COR)).DESCRICAO,
                    FORNECEDOR: codigoFornecedor,
                    NOME: nomeForncedor.NOME,
                    CODIGO: codigoMaterialProduto,
                    DESCRICAO: $('#rdMaterial').is(':checked') ? nomeMaterial.DESCRICAO : nomeProduto.DESCRICAO,
                    UNIDADE: (await UNIDADE()).UNIDADE,
                    UNI_COM: $('#rdMaterial').is(':checked') ? (await UNI_COM()).UNI_COM : (await UNI_COM()).UNI_VENDA,
                    CODIGO2: (await CODIGO2()).CODIGO2,
                    COD_FORNECEDOR: '',
                    COR_FORNECEDOR: '',
                    DIAS: '',
                    DIAS_PREPARACAO: '',
                    DT_ATUALIZA: formataDataCompleta(new Date()),
                    PRECO: '',
                    PERC_IPI: '',
                    QTDE_MIN: '',
                    QTDE_MAX: '',
                    PERC_FRETE: 0,
                    PERC_DIF_ICMS: 0,
                    PERC_ST_ICMS: 0,
                    PERC_OUTROS: 0,
                    PANTONE: coresSemCadCorTi[i]?.pantone,
                    CODIGO2: '',
                    COR2: coresSemCadCorTi[i]?.cor2,
                };

                function adicionarLinhaComCor(novaLinha, cor) {
                    let tabela = $("#tabelaCorCompra").DataTable();
                    let linha = tabela.row.add(novaLinha).draw().node();

                    $(linha).addClass('novaLinha'); // Adiciona a classe 'novaLinha' ao novo registro

                    $(linha).css('background-color', cor);

                    let data = novaLinha.COR;
                    $(linha).find('td:first-child').html(retornaBotaoOpcoes(data, true));
                    $(linha).find('.btnVerificaOpcoes').attr('id', 'btnVerificaOpcoesNovo');
                }


                async function adicionarNovosRegistros(novosDados) {
                    for (let i = 0; i < novosDados.length; i++) {
                        adicionarLinhaComCor(novosDados[i]);
                    }
                }
                adicionarNovosRegistros([newData]);
            };
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados da Cor Compra.`);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnConsultar').on('click', async () => {
        if ($('#txtFornecedor').val() == '') {
            msgErro('Preencha o campo de Fornecedor.');
            return;
        }

        if ($('#rdMaterial').is(':checked') && $('#txtMaterial').val() == '') {
            msgErro('Preencha o campo de Material.');
            return;
        }

        if ($('#rdProduto').is(':checked') && $('#txtProduto').val() == '') {
            msgErro('Preencha o campo de Produto.');
            return;
        }

        await buscarCadCorti();
    });

    // Atualiza valores na tabela
    $('#btnConfirmar').on('click', async () => {
        const novoValor = $('#txtValor').val().trim();

        const tabela = $('#tabelaCorCompra').DataTable();
        const registrosTabela = tabela.rows().data();

        if (registrosTabela.length === 0) {
            msgAlerta('Nenhum item encontrado na tabela!');
            return;
        }

        if (novoValor === '') {
            msgAlerta('Por favor, insira um valor.');
            return;
        }

        msgAlerta(`Tem certeza que deseja setar todos os valores para ${novoValor}?`, () => { }, () => { },
            async () => {
                try {
                    $.LoadingOverlay("show");

                    registrosTabela.each(function (value, index) {
                        value['PRECO'] = novoValor;

                        const linha = tabela.row(index).node();
                        if ($(linha).find('.campoValor').length > 0) {
                            $(linha).find('.campoValor').val(novoValor);
                        }
                    });

                    tabela.rows().invalidate().draw(false); //atualiza a tabela
                    aplicarMascara();

                } finally {
                    $.LoadingOverlay("hide");
                }
            },
            () => { },
            () => { });
    });

    function retornaBotaoOpcoes(data, disabled = false) {
        var disabledAttr = disabled ? 'disabled' : '';
        var classeDesabilitada = disabled ? 'botaoDesabilitado' : '';
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes ' + classeDesabilitada + '" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" ' + disabledAttr + '> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir" ' + disabledAttr + '>Excluir</button>  ' +
            '</div>';
        return retorno;
    }


    $('#tabelaCorCompra').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaCorCompra").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/cadastros/v1/deletacorcompra?", `CODIGO=${(valorLinha.CODIGO)}&COR=${(valorLinha.COR)}&CODCLI=${codigoFornecedor}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }


    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CORCOMPRA', getCookie('usuario'), String(corcompra));
        window.location.href = `${BASE_URI}/corcompra`;
    });

    $("#btnGravar").click(
        async function () {
            try {
                $.LoadingOverlay("show");
                const tabelaCorCompra = $('#tabelaCorCompra').DataTable();
                const corcompra = [];

                tabelaCorCompra.rows().every(function (index) {
                    const linha = $(this.node());
                    const data = this.data();
                    const preco = parseFloat(linha.find('.campoValor').val()) || 0.0;
                    const itenTabela = {
                        preco,
                        codcli: data.FORNECEDOR,
                        cor: data.COR,
                        codigo: data.CODIGO,
                        tipoItem: $('#rdMaterial').is(':checked') ? 'M' : 'P',
                        dataAtualiza: $(`#txtDataAtualiza_${index}`).val() || formataData(new Date()),
                        corFornecedor: $(`#txtCorFornecedor_${index}`).val(),
                        dias: $(`#txtDias_${index}`).val(),
                        percIpi: $(`#txtPercIpi_${index}`).val(),
                        diasPreparacao: $(`#txtDiasPreparacao_${index}`).val(),
                        quantidadeMinima: $(`#txtQuantidadeMinima_${index}`).val(),
                        quantidadeMaxima: $(`#txtQuantidadeMaxima_${index}`).val(),
                        codigoFornecedor: $(`#txtCodigoFornecedor_${index}`).val(),
                        percFrete: $(`#txtPercFrete_${index}`).val(),
                        percDifIcms: $(`#txtPercDifIcms_${index}`).val(),
                        percStIcms: $(`#txtPercStIcms_${index}`).val(),
                        percOutros: $(`#txtPercOutros_${index}`).val(),
                    };
                    corcompra.push(itenTabela);
                });

                let response = await requisicao('POST', '/sisplan/cadastros/v1/gravacorcompra?', '', JSON.stringify({ listaCorCompra: corcompra }), 360000);


                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                if (response.status != 200) {
                    let jsonStr = await response.json();
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    `Cadastro efetuado com sucesso!`,
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/corcompra`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });


            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados da situação`);
            }

        });
});