$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoFluxo",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir um novo fluxo.",
          position: "right",
        },
      },
      {
        element: "#tabelaFluxo",
        popover: {
          title: "Tabela Fluxo",
          description: "Aqui estão os dados dos fluxos cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $('.duasCasasDecimaisCurrencyFormat').off('input focusout')
  $('.duasCasasDecimaisCurrencyFormat').on('input', function () {
    let val = $(this).val()
    val = val.replace('.', ',')
    val = val.replace(/[^0-9,]/g, '')
    const parts = val.split(',')
    if (parts.length > 2) {
      val = parts[0] + ',' + parts.slice(1).join('')
    }

    if (parts[1]?.length > 2) {
      parts[1] = parts[1].slice(0, 2)
      val = parts.join(',')
    }

    const valNumerico = val.replace(',', '').replace(/^0+/, '')
    if (valNumerico === '') {
      $(this).val('')
      return
    }

    $(this).val(val)
  })

  $('.duasCasasDecimaisCurrencyFormat').on('focusout', function () {
    let val = $(this).val().trim()

    if (!val) {
      $(this).val('0,00')
      return
    }

    if (val.startsWith(',')) {
      val = '0' + val
    }

    if (!val.includes(',')) {
      val += ',00'
    } else {
      const parts = val.split(',')
      const decimal = parts[1] || ''
      const preenchido = decimal.padEnd(2, '0')
      val = parts[0] + ',' + preenchido
    }

    $(this).val(val)
  })

  $('.quatroCasasDecimaisCurrencyFormat').off('input focusout')
  $('.quatroCasasDecimaisCurrencyFormat').on('input', function () {
    let val = $(this).val()
    val = val.replace('.', ',')
    val = val.replace(/[^0-9,]/g, '')
    const parts = val.split(',')
    if (parts.length > 4) {
      val = parts[0] + ',' + parts.slice(1).join('')
    }

    if (parts[1]?.length > 4) {
      parts[1] = parts[1].slice(0, 4)
      val = parts.join(',')
    }

    const valNumerico = val.replace(',', '').replace(/^0+/, '')
    if (valNumerico === '') {
      $(this).val('')
      return
    }

    $(this).val(val)
  })

  $('.quatroCasasDecimaisCurrencyFormat').on('focusout', function () {
    let val = $(this).val().trim()

    if (!val) {
      $(this).val('0,0000')
      return
    }

    if (val.startsWith(',')) {
      val = '0' + val
    }

    if (!val.includes(',')) {
      val += ',0000'
    } else {
      const parts = val.split(',')
      const decimal = parts[1] || ''
      const preenchido = decimal.padEnd(4, '0')
      val = parts[0] + ',' + preenchido
    }

    $(this).val(val)
  })

  $('.somenteInteirosFormat').off('input focusout')
  $('.somenteInteirosFormat').on('input', function () {
    let val = $(this).val()

    val = val.replace(/[^0-9]/g, '')

    val = val.replace(/^0+/, '')

    $(this).val(val)
  })

  $('.somenteInteirosFormat').on('focusout', function () {
    let val = $(this).val().trim()

    if (!val) {
      $(this).val('0')
    }
  })

  const permissoesUsuarioLogado = await permissaoAcessos("FORMACAO_CUSTOS");

  preencherFiltrosSalvos()
  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show')
  })

  $('#btnIncluir').on('click', function () {
    if (permissoesUsuarioLogado.INCLUI !== 'S') {
      msgAlertaSemConfirmacao('Sem permissão para incluir!')
      return
    }
    window.location.href = 'formacao_custos/create'
  })

  limparFiltros(true)

  componenteFiltro('produto', true, true)

  async function retornarFiltros() {
    return {
      produtos: await formataListas($('#txtProduto').val().toString())
    }
  }

  $('#btnConsultar').on('click', function () {
    consultar().then(() => $('#modal-filtros').modal('hide'))
  })

  async function consultar() {
    const filtros = await retornarFiltros()
    atualizarFiltrosAbasAcessoSessionStorage('formacao_custos', filtros)
    carregarTabelaItens(filtros)
  }

  carregarTabelaItens()

  function carregarTabelaItens(filtros) {

    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }

    const columns = [
      {
        data: 'id',
        title: 'Id',
        render: function (data) {
          return retornarBotaoOpcoes(data);
        },
      },
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'padrao',
        title: 'Padrão',
        render: function (data) {
          return data ? 'Sim' : 'Não'
        }
      },
      {
        data: 'dataCadastro',
        title: 'Cadastro',
        render: function (data) {
          return retornarDataISOEmYMD({ dataISO: data, reverso: true })
        }
      },
      {
        data: 'dataUltimaAtualizacao',
        title: 'Última Atualização',
        render: function (data) {
          return retornarDataISOEmYMD({ dataISO: data, reverso: true })
        }
      },
      {
        data: 'status',
        title: 'Status',
        render: function (data) {
          return '1' ? 'Fechado' : 'Aberto'
        },
      },
      {
        data: 'markup',
        title: 'Markup',
      },
      {
        data: 'prazoPadrao',
        title: 'Prazo Padrão',
      },
      {
        data: 'custo',
        title: 'Custo',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0, quantidadeCasasDecimais: 6 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
        },
      },
      {
        data: 'precoVenda',
        title: 'Preço Venda',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0, quantidadeCasasDecimais: 6 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
        },
      },
    ]

    $('#tabelaItens').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: true,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      colReorder: true,
      serverSide: true,
      ajax: {
        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/formacaocustos/v1/dadosacesso`,
        type: "POST",
        headers: {
          'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
        },
        data: {
          EMPRESA: getCookie('empresa'),
          FILTROS: JSON.stringify(filtros) ?? "{}",
        },
        dataSrc: function (json) {
          if (!json || !json.data) {
            return []
          }
          return json.data
        },
        cache: true,
        beforeSend: function () {
          $.LoadingOverlay('show')
        },
        complete: function () {
          $.LoadingOverlay('hide')
        },
      },
      autoWidth: true,
      columns,
      scrollX: true,
      scrollY: '55vh',
    })
  }

  function retornarBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '    <button class="dropdown-item" type="button" title="Finalizar" id="btnFinalizar">Finalizar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Margem" id="btnMargem">Margem</button>     ' +
      '</div>'
    return retorno
  }

  $('#tabelaItens').on('click', '#btnEditar', async function () {
    if (permissoesUsuarioLogado.ALTERA !== 'S') {
      msgAlertaSemConfirmacao('Sem permissão para alterar!')
      return
    }
    let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data();
    window.location.href = `formacao_custos/${data?.id}`
  })

  $('#tabelaItens').on('click', '#btnExcluir', async function () {
    if (permissoesUsuarioLogado.EXCLUI !== 'S') {
      msgAlertaSemConfirmacao('Sem permissão para excluir!')
      return
    }
    const linha = $('#tabelaItens').DataTable().row($(this).parents('tr'))

    let data = linha.data();

    msgAlerta(
      'Deseja realmente excluir esse item?',
      () => null,
      () => null,
      async () => {
        const result = await excluir(data?.id)

        if (result) {
          linha.remove().draw(false)
        }
      }
    )
  })

  $('#tabelaItens').on('click', '#btnFinalizar', async function () {
    if (permissoesUsuarioLogado.ALTERA !== 'S') {
      msgAlertaSemConfirmacao('Sem permissão para alterar!')
      return
    }
    let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data();
    carregarModalFinalizacao(data)
  })

  $('#tabelaItens').on('click', '#btnMargem', async function () {
    if (permissoesUsuarioLogado.ALTERA !== 'S') {
      msgAlertaSemConfirmacao('Sem permissão para alterar!')
      return
    }
    let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data();
    carregarModalMargem(data)
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    if (permissoesUsuarioLogado.ALTERA !== 'S') {
      msgAlertaSemConfirmacao('Sem permissão para alterar!')
      return
    }
    const data = $('#tabelaItens').DataTable().row($(this)).data();
    if (!data) {
      return
    }
    window.location.href = `formacao_custos/${data.id}`;
  });

  function preencherFiltrosSalvos() {
    const filtrosSessionStorage = sessionStorage.getItem('filtrosConsultasAbasAcesso')
    if (filtrosSessionStorage) {
      const { formacao_custos: filtros } = JSON.parse(filtrosSessionStorage)
      if (filtros) {
        carregarFiltrosSalvos(filtros).then(({ produtos }) => {
          if (produtos) produtos.forEach((item) => adicionaValorPadraoVarios('produto', item?.codigo, item?.descricao))
          consultar()
        }).catch(
          () => msgErro('Ocorreu um erro ao preencher os filtros salvos.')
        )
      }
    }
  }

  async function carregarFiltrosSalvos(dados) {
    const response = await requisicao("POST", `/Sisplan/formacaocustos/v1/filtrosacesso?`, '', JSON.stringify(dados), 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function carregarModalFinalizacao({ id, codigo, descricao }) {
    if (!id) {
      return
    }
    $.LoadingOverlay('show')
    $('#tituloModalFinalizacao').html(`[${codigo}] - ${descricao}`)
    $('#txtIdPrecoFinalizacao').val(id)
    $('#txtCodigoProdutoFinalizacao').val(codigo)
    $('#txtDescricaoProdutoFinalizacao').val(descricao)
    buscarDadosFinalizacao(id).then(({ tabelaPrecoPadrao, status, prazos, precos, precosCotacao, pedido, itensPreco }) => {
      insereValor('#txtTabelaPrecoFinalizacao', tabelaPrecoPadrao?.codigo, tabelaPrecoPadrao?.descricao)
      $('#txtPedidoFinalizacao').val(pedido)
      $('#selectStatusFinalizacao').val(status?.toString())
      $('#txtPrecoRealFinalizacao').val(precos?.precoAVista)
      $('#txtPrecoDolarFinalizacao').val(precosCotacao?.dolar)
      $('#txtPrecoEuroFinalizacao').val(precosCotacao?.euro)
      preencherPrazosFinalizacao(prazos)
      preencherPrecosFinalizacao(precos)
      criarTabelaItensPreco(itensPreco)
      $('#modalFinalizacao').modal('show')
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  async function buscarDadosFinalizacao(id) {
    const response = await requisicao("GET", `/sisplan/formacaocustos/v1/finalizacao?`, `ID=${id}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function preencherPrazosFinalizacao(prazos) {
    if (!prazos) return
    $('#txtPrazo07Finalizacao').val(prazos.prazo1)
    $('#txtPrazo14Finalizacao').val(prazos.prazo2)
    $('#txtPrazo21Finalizacao').val(prazos.prazo3)
    $('#txtPrazo28Finalizacao').val(prazos.prazo4)
    $('#txtPrazo35Finalizacao').val(prazos.prazo5)
    $('#txtPrazo42Finalizacao').val(prazos.prazo6)
    $('#txtPrazo49Finalizacao').val(prazos.prazo7)
  }

  function preencherPrecosFinalizacao(precos) {
    if (!precos) return
    $('#txtPrecoAVistaFinalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.precoAVista }))
    $('#txtPreco1Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco1 }))
    $('#txtPreco2Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco2 }))
    $('#txtPreco3Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco3 }))
    $('#txtPreco4Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco4 }))
    $('#txtPreco5Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco5 }))
    $('#txtPreco6Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco6 }))
    $('#txtPreco7Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco7 }))
  }

  function preencherPrecosOriginaisFinalizacao(precos) {
    if (!precos) return
    $('#txtPrecoOriginalAVistaFinalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.precoAVista }))
    $('#txtPrecoOriginal1Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco1 }))
    $('#txtPrecoOriginal2Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco2 }))
    $('#txtPrecoOriginal3Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco3 }))
    $('#txtPrecoOriginal4Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco4 }))
    $('#txtPrecoOriginal5Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco5 }))
    $('#txtPrecoOriginal6Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco6 }))
    $('#txtPrecoOriginal7Finalizacao').val(retornarFloatFormatadoEmMonetario({ valor: precos.preco7 }))
  }

  $('#btnRecalcularFinalizacao').on('click', function () {
    recalcularPrecosFinalizacao()
  })

  function recalcularPrecosFinalizacao() {
    const precos = retornarPrecosFinalizacao()
    const precosRecalculados = retornarPrecosFinalizacaoRecalculados({ precos })
    $('#txtPrecoRealFinalizacao').val(precosRecalculados?.precoAVista)
    preencherPrecosFinalizacao(precosRecalculados)
  }

  function recalcularPorIndice(valor, percentual) {
    try {
      return valor * (1 + (percentual / 100))
    } catch (error) {
      return 0
    }
  }

  function recalcularPorPercentual(valor, percentual) {
    try {
      return valor / ((100 - percentual) / 100)
    } catch (error) {
      return 0
    }
  }

  function recalcularPorIndiceMarkup(valor, percentual) {
    try {
      return valor / (1 - percentual)
    } catch (error) {
      return 0
    }
  }

  function retornarPrecosFinalizacao() {
    const precoAVista = retornarValorMonetarioEmFloat($('#txtPrecoAVistaFinalizacao').val())
    const preco1 = retornarValorMonetarioEmFloat($('#txtPreco1Finalizacao').val())
    const preco2 = retornarValorMonetarioEmFloat($('#txtPreco2Finalizacao').val())
    const preco3 = retornarValorMonetarioEmFloat($('#txtPreco3Finalizacao').val())
    const preco4 = retornarValorMonetarioEmFloat($('#txtPreco4Finalizacao').val())
    const preco5 = retornarValorMonetarioEmFloat($('#txtPreco5Finalizacao').val())
    const preco6 = retornarValorMonetarioEmFloat($('#txtPreco6Finalizacao').val())
    const preco7 = retornarValorMonetarioEmFloat($('#txtPreco7Finalizacao').val())

    return {
      precoAVista,
      preco1,
      preco2,
      preco3,
      preco4,
      preco5,
      preco6,
      preco7,
    }
  }

  function retornarPrecosFinalizacaoRecalculados({ precos }) {
    if (!precos) return
    const percentual = retornarValorMonetarioEmFloat($('#txtPercentualRecalcularFinalizacao').val())
    const tipoRecalculo = $('#selectRecalculoFinalizacao').val()
    let recalcular
    switch (tipoRecalculo) {
      case 'indice':
        recalcular = recalcularPorIndice
        break
      case 'percentual':
        recalcular = recalcularPorPercentual
        break
      case 'indiceMarkup':
        recalcular = recalcularPorIndiceMarkup
        break
      default:
        break
    }

    if (!recalcular) {
      return
    }

    const novoPrecoAVista = recalcular(precos.precoAVista, percentual)
    const novoPreco1 = recalcular(precos.preco1, percentual)
    const novoPreco2 = recalcular(precos.preco2, percentual)
    const novoPreco3 = recalcular(precos.preco3, percentual)
    const novoPreco4 = recalcular(precos.preco4, percentual)
    const novoPreco5 = recalcular(precos.preco5, percentual)
    const novoPreco6 = recalcular(precos.preco6, percentual)
    const novoPreco7 = recalcular(precos.preco7, percentual)

    return {
      precoAVista: novoPrecoAVista,
      preco1: novoPreco1,
      preco2: novoPreco2,
      preco3: novoPreco3,
      preco4: novoPreco4,
      preco5: novoPreco5,
      preco6: novoPreco6,
      preco7: novoPreco7,
    }
  }

  $('#selectTipoPrecoFinalizacao').on('change', function () {
    switch (this.value) {
      case 'real': {
        const preco = retornarValorMonetarioEmFloat($('#txtPrecoRealFinalizacao').val())
        $('#txtPrecoAVistaFinalizacao').val(retornarFloatFormatadoEmMonetario({ valor: preco }))
        break
      }
      case 'dolar': {
        const preco = retornarValorMonetarioEmFloat($('#txtPrecoDolarFinalizacao').val())
        $('#txtPrecoAVistaFinalizacao').val(retornarFloatFormatadoEmMonetario({ valor: preco }))
        break
      }
      case 'euro': {
        const preco = retornarValorMonetarioEmFloat($('#txtPrecoEuroFinalizacao').val())
        $('#txtPrecoAVistaFinalizacao').val(retornarFloatFormatadoEmMonetario({ valor: preco }))
        break
      }
    }
  })

  componenteFiltro('tabPreco', false, false, 'TabelaPrecoFinalizacao')

  $('#txtPedidoFinalizacao').autocompleta(3, `JSON={ "tabela":"PEDIDO", "camposSelect":["NUMERO CHAVE, CODCLI DESCRICAO"], "where": [] }`, ['#txtPedidoFinalizacao'], ['CHAVE'], ['DESCRICAO'], undefined, [true], '', [], true)
  $('#btnPedidoFinalizacao').pesquisa_serverside(['#txtPedidoFinalizacao'], ['NUMERO', 'CODCLI'], ['NUMERO', 'CODCLI'], '{"tabela":"PEDIDO", "camposSelect":["NUMERO", "CODCLI"], "where": null}', 'Pesquisa Pedido', undefined, [true])
  $('#btnLimpaPedidoFinalizacao').on('click', function () {
    $('#txtPedidoFinalizacao').val('')
  })

  $('#btnGravarFinalizacao').on('click', function () {
    const dados = retornarDadosGravarFinalizacao()
    if (!validarDadosGravarFinalizacao(dados)) {
      return
    }

    gravarFinalizacao(dados)
  })

  function retornarDadosGravarFinalizacao() {
    const dadosTabelaPreco = retornarChaveDescricao('#txtTabelaPrecoFinalizacao')
    const status = $('#selectStatusFinalizacao').val()
    const precos = retornarPrecosFinalizacao()
    const pedido = $('#txtPedidoFinalizacao').val()
    const produto = {
      codigo: $('#txtCodigoProdutoFinalizacao').val(),
      descricao: $('#txtDescricaoProdutoFinalizacao').val(),
    }
    const idPreco = $('#txtIdPrecoFinalizacao').val()
    const atualizarPrecosTabelaPreco = $('#cbGravarPrecosTabelaPrecoFinalizacao').prop('checked')

    return {
      tabelaPreco: {
        codigo: dadosTabelaPreco.chave,
        descricao: dadosTabelaPreco.descricao,
      },
      status,
      precos,
      pedido,
      produto,
      idPreco,
      atualizarPrecosTabelaPreco,
    }
  }

  function validarDadosGravarFinalizacao(dados) {
    if (dados?.atualizarPrecosTabelaPreco && !dados.tabelaPreco?.codigo) {
      msgErro('Tabela de preço não informada, impossível continuar.')
      return false
    }

    return true
  }

  async function gravarFinalizacao(dados) {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao("POST", `/sisplan/formacaocustos/v1/finalizacao?`, '', JSON.stringify(dados), 3600000)
      const json = await response.json()

      if (!json) {
        return
      }
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }


      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          criarTabelaItensPreco(resultado?.itensPreco)
        }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao gravar os dados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#modalFinalizacao').on('hidden.bs.modal', function () {
    $('#modalFinalizacao input').val('')
    $('#txtPrazoAVistaFinalizacao').val('À vista')
    $('#selectRecalculoFinalizacao').val('indice')
    $('#selectTipoPrecoFinalizacao').val('real')
    $('#selectStatusFinalizacao').val('0')
    $('#cbGravarPrecosTabelaPrecoFinalizacao').prop('checked', false)
  })

  function criarTabelaItensPreco(data = []) {
    if ($.fn.DataTable.isDataTable('#tabelaItensPreco')) {
      $('#tabelaItensPreco').DataTable().destroy()
      $('#tabelaItensPreco').empty()
    }

    const columns = [
      {
        data: 'codigoTabela',
        title: 'Código Tabela',
      },
      {
        data: 'descricaoTabela',
        title: 'Descrição Tabela',
      },
      {
        data: 'preco00',
        title: 'Preço 00',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco07',
        title: 'Preço 07',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco14',
        title: 'Preço 14',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco21',
        title: 'Preço 21',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco28',
        title: 'Preço 28',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco35',
        title: 'Preço 35',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco42',
        title: 'Preço 42',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco49',
        title: 'Preço 49',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco56',
        title: 'Preço 56',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco63',
        title: 'Preço 63',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco70',
        title: 'Preço 70',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco77',
        title: 'Preço 77',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco84',
        title: 'Preço 84',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco91',
        title: 'Preço 91',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return retornarFloatFormatadoEmMonetario({ valor: 0 })
          }
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
    ]

    const table = $("#tabelaItensPreco").DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '250px',
      select: {
        style: 'single',
        toggleable: false,
      },
    }).draw(false)

    let indiceLinhaSelecionadaTabelaItens = 0

    table.off('select')
    table.on('select', function (_e, _dt, type, indexes) {
      if (type === 'row') {
        indiceLinhaSelecionadaTabelaItens = indexes[0]
        const data = $(this).DataTable().row(indiceLinhaSelecionadaTabelaItens).data()
        if (!data) {
          return
        }
        insereValor('#txtTabelaPrecoFinalizacao', data.codigoTabela, data.descricaoTabela)
        const precos = {
          precoAVista: data.preco00,
          preco1: data.preco07,
          preco2: data.preco14,
          preco3: data.preco21,
          preco4: data.preco28,
          preco5: data.preco35,
          preco6: data.preco42,
          preco7: data.preco49,
        }

        preencherPrecosOriginaisFinalizacao(precos)
      }
    })
  }

  $('#modalFinalizacao').on('shown.bs.modal', function () {
    $('#tabelaItensPreco').DataTable().columns.adjust().draw(false)
  })

  function carregarModalMargem({ id, codigo, descricao }) {
    $.LoadingOverlay('show')
    $('#txtIdPrecoMargem').val(id)
    buscarDadosMargem(id).then((dados) => {
      if (!dados) {
        return
      }

      preencherDadosMargem(dados)
      $('#modalMargem').modal('show')
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  async function buscarDadosMargem(id) {
    const response = await requisicao("GET", `/sisplan/formacaocustos/v1/margem?`, `ID=${id}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function preencherDadosMargem({
    indiceMargemLucro,
    custoIndustrialFixo,
    prazoPadrao,
    precoAVista,
    precoVenda,
  }) {
    const indiceMargemLucroFormatado = retornarFloatFormatadoEmMonetario({ valor: indiceMargemLucro, quantidadeCasasDecimais: 4 })
    $('#txtPercentualLucroAnteriorMargem').val(indiceMargemLucroFormatado)
    $('#txtPercentualLucroMargem').val(indiceMargemLucroFormatado)
    $('#txtNovaMargemMargem').val(indiceMargemLucroFormatado)
    if (custoIndustrialFixo > 0) {
      $('#txtCustoIndustrialFixoMargem').val(retornarFloatFormatadoEmMonetario({ valor: custoIndustrialFixo, quantidadeCasasDecimais: 4 }))
      $('.custoIndustrialFixoMargem').removeClass('d-none')
    }
    $('#txtPrazoMargem').val(prazoPadrao)
    $('#txtPrazoPadraoMargem').val(prazoPadrao)
    $('#txtPrecoAVistaMargem').val(retornarFloatFormatadoEmMonetario({ valor: precoAVista, quantidadeCasasDecimais: 4 }))
    $('#txtPrecoVendaMargem').val(retornarFloatFormatadoEmMonetario({ valor: precoVenda, quantidadeCasasDecimais: 4 }))
  }

  $('#txtPrazoMargem').on('blur', function () {
    const precoOriginal = retornarValorMonetarioEmFloat($('#txtPrecoVendaMargem').val())
    const custoIndustrialFixo = retornarValorMonetarioEmFloat($('#txtCustoIndustrialFixoMargem').val())
    const idPreco = $('#txtIdPrecoMargem').val()
    const prazo = $('#txtPrazoMargem').val()

    $.LoadingOverlay('show')
    retornarMargemRecalculada({
      precoOriginal,
      custoIndustrialFixo,
      idPreco,
      prazo,
    }).then((dados) => {
      if (!dados) {
        return
      }
      const indiceMargemLucroFormatado = retornarFloatFormatadoEmMonetario({ valor: dados.indiceMargemLucro, quantidadeCasasDecimais: 4 })
      $('#txtNovaMargemMargem').val(indiceMargemLucroFormatado)
      $('#txtPercentualLucroMargem').val(indiceMargemLucroFormatado)
      $('#txtPrecoAVistaMargem').val(retornarFloatFormatadoEmMonetario({ valor: dados.precoAVista, quantidadeCasasDecimais: 4 }))
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao recalcular a margem.')
    }).finally(() => $.LoadingOverlay('hide'))
  })

  $('#txtPercentualLucroMargem').on('blur', function () {
    const margemLucro = retornarValorMonetarioEmFloat($('#txtPercentualLucroMargem').val())
    const precoOriginal = retornarValorMonetarioEmFloat($('#txtPrecoVendaMargem').val())
    const custoIndustrialFixo = retornarValorMonetarioEmFloat($('#txtCustoIndustrialFixoMargem').val())
    const idPreco = $('#txtIdPrecoMargem').val()
    const prazo = $('#txtPrazoMargem').val()

    $.LoadingOverlay('show')
    retornarMargemRecalculada({
      margemLucro,
      precoOriginal,
      custoIndustrialFixo,
      idPreco,
      prazo,
    }).then((dados) => {
      if (!dados) {
        return
      }
      const indiceMargemLucroFormatado = retornarFloatFormatadoEmMonetario({ valor: margemLucro, quantidadeCasasDecimais: 4 })
      $('#txtNovaMargemMargem').val(indiceMargemLucroFormatado)
      $('#txtPercentualLucroMargem').val(indiceMargemLucroFormatado)
      $('#txtPrecoAVistaMargem').val(retornarFloatFormatadoEmMonetario({ valor: dados.precoAVista, quantidadeCasasDecimais: 4 }))
      $('#txtPrecoVendaMargem').val(retornarFloatFormatadoEmMonetario({ valor: dados.precoVenda, quantidadeCasasDecimais: 4 }))
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao recalcular a margem.')
    }).finally(() => $.LoadingOverlay('hide'))
  })

  async function retornarMargemRecalculada({
    margemLucro = 0,
    precoOriginal,
    custoIndustrialFixo,
    idPreco,
    prazo,
  }) {
    const response = await requisicao("POST", `/sisplan/formacaocustos/v1/recalcularmargem?`, `MARGEM_LUCRO=${margemLucro}&PRECO_ORIGINAL=${precoOriginal}&CUSTO_INDUSTRIAL_FIXO=${custoIndustrialFixo}&ID_PRECO=${idPreco}&PRAZO=${prazo}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  $('#btnGravarMargem').on('click', function () {
    const dados = retornarDadosGravarMargem()
    if (!validarDadosGravarMargem(dados)) {
      return
    }
    gravarMargem(dados)
  })

  function retornarDadosGravarMargem() {
    const prazoPadrao = $('#txtPrazoPadraoMargem').val()
    const prazo = $('#txtPrazoMargem').val()
    const indiceMargemLucro = retornarValorMonetarioEmFloat($('#txtNovaMargemMargem').val())
    const precoVenda = retornarValorMonetarioEmFloat($('#txtPrecoVendaMargem').val())
    const idPreco = $('#txtIdPrecoMargem').val()

    return {
      prazoPadrao,
      prazo,
      indiceMargemLucro,
      precoVenda,
      idPreco,
    }
  }

  function validarDadosGravarMargem(dados) {
    if (!dados) {
      msgErro('Dados inválidos, impossível continuar.')
      return false
    }

    if (dados.prazoPadrao !== dados.prazo) {
      msgErro('Prazo diferente do prazo padrão, impossível continuar.')
      return false
    }

    return true
  }

  async function gravarMargem(dados) {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao("POST", `/sisplan/formacaocustos/v1/margem?`, '', JSON.stringify(dados), 3600000)
      const json = await response.json()

      if (!json) {
        return
      }
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          $('#modalMargem').modal('hide')
        }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao gravar os dados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function excluir(id) {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao("DELETE", `/sisplan/formacaocustos/v1/preco?`, `ID=${id}`, '', 3600000)
      const json = await response.json()

      if (!json) {
        return
      }
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() { }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })

      return true
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao excluir os dados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }
})