$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar o pedido a ser liberado.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de pedidos.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear os pedidos selecionados.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  addPesquisaAutocompleta();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.pedido == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, liberacaoFinanceiraPedidos: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, liberacaoFinanceiraPedidos: novasColunas }))
      $('#tabelaPedido').DataTable().columns().visible(true);
      $('#tabelaPedido').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPedido').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });
    adicionaColunas(cols, colunasInvisiveis.liberacaoFinanceiraPedidos ?? [], ['Selecionar'])
  })
  /////COLUNAS INVISIVEIS

  $('#btnConsultar').on('click', async () => { await buscaPedidos() });

  $('#tabelaPedido').on('click', 'tr', async function () {
    $('.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await buscaDadosPedido($(this).closest('tr')[0].children[1].innerHTML, $(this).closest('tr')[0].children[2].innerHTML);
  });

  $('#btnLiberar').on('click', async function () {
    await gravaDados();
  });

  async function gravaDados() {
    let arrPedidos = [];
    const liberarBloquear = $('#radioLiberar').prop('checked') ? '1' : '0';
    const mensagem = liberarBloquear == '0' ? pegaValor('#txtMotivo') : ''
    if (liberarBloquear == '0' && mensagem == '') {
      msgAlerta('Para prosseguir com o bloqueio de pedidos, é necessário informar o motivo.')
      return
    }

    $('.selecionado').closest('tr').map((index, item) => {
      arrPedidos.push({
        NUMERO: item.children[1].innerHTML,
        CODCLI: item.children[2].innerHTML,
        FINANCEIRO: liberarBloquear
      })
    });

    if (arrPedidos.length == 0) {
      msgAlerta('Nenhum pedido selecionado para liberar.');
      return;
    }

    const response = await requisicao('POST', '/sisplan/pedido/v1/liberapedido?', 'TELA=LIBERACAO_FINANCEIRO_WEB', JSON.stringify({ PEDIDOS: arrPedidos, MENSAGEM: mensagem }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
    criaMensagemSucesso('Liberação efetuada com sucesso.', () => { window.location.reload() })
  }

  async function buscaDadosPedido(sPedido, sCodcli) {
    $.LoadingOverlay('show');
    try {
      const itens = await retornaItens(sPedido);
      insereItens(itens);

      await retornaReceber(sCodcli);
    } catch (err) {
      console.error(err)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaPedidos() {
    $.LoadingOverlay('show');
    try {
      const sWhere = retornaFiltro();
      const sGroupBy = retornaGroupBy();
      const dados = await retornaDados(sWhere, sGroupBy);;

      if (dados.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
        return;
      }

      insereDadosTabela(dados);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function retornaDados(sWhere, sGroupBy) {
    const listaLeftJoin = [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' }, { tabela: 'PED_ITEN', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' }]
    const camposSelect = ['PEDIDO.NUMERO',
      'ENTIDADE.NOME',
      'ENTIDADE.CODCLI',
      'SUM(PED_ITEN.QTDE) QTDE_PEND',
      'SUM(PED_ITEN.QTDE * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_PEND',
      'SUM(PED_ITEN.QTDE_F) QTDE_FAT',
      'SUM(PED_ITEN.QTDE_F * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_FAT',
      'SUM(PED_ITEN.QTDE_CANC) QTDE_CANC',
      'SUM(PED_ITEN.QTDE_CANC * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_CANC',
      'SUM(PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) QTDE_TOT',
      'SUM((PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_TOT',];
    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect,
      leftJoin: listaLeftJoin,
      where: [`${sWhere}`],
      groupBy: [sGroupBy]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect;
  }

  async function retornaReceber(sCodcli) {

    const dadosSelect = {
      tabela: 'RECEBER',
      camposSelect: ['RECEBER.NUMERO', 'RECEBER.DT_EMISSAO', 'RECEBER.DT_VENCTO', 'MAX(RECEBERB.DT_PAGTO) AS DT_PAGTO',
        'RECEBER.SITUACAO', 'TABSIT.DESCRICAO AS DESCSIT', 'RECEBER.VALOR2 AS VALOR', 'CADBAN.BANCO', 'CADBAN.NOME_BANCO',
        'RECEBER.VALOR_PAGO', 'RECEBER.STATUS'],
      leftJoin: [{ tabela: 'TABSIT', condicao: 'RECEBER.SITUACAO = TABSIT.CODIGO' },
      { tabela: 'RECEBERB', condicao: 'RECEBER.NUMERO = RECEBERB.NUMERO' },
      { tabela: 'CADBAN', condicao: 'CADBAN.BANCO = RECEBER.BANCO' }],
      where: [`RECEBER.CODCLI = '${sCodcli}'`,
        `((RECEBER.VALOR2 [SOMA] RECEBER.JUROS) > (RECEBER.VALOR_PAGO [SOMA] RECEBER.DESCONTO [SOMA] RECEBER.VAL_DEV))`,
        `RECEBER.STATUS NOT IN ('DESD', 'AGRU', 'CANC')`],
      groupBy: ['RECEBER.NUMERO', 'RECEBER.DT_EMISSAO', 'RECEBER.DT_VENCTO',
        'RECEBER.SITUACAO', 'TABSIT.DESCRICAO', 'RECEBER.VALOR2', 'CADBAN.BANCO', 'CADBAN.NOME_BANCO',
        'RECEBER.VALOR_PAGO', 'RECEBER.STATUS',],
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      throw new Error('Não foi possível buscar os dados do receber do pedido.')
    }

    const dataSetCols = [
      { title: "Número", data: 'NUMERO' },
      { title: "Emissão", data: 'DT_EMISSAO' },
      { title: "Vencimento", data: 'DT_VENCTO' },
      { title: "Data Pag.", data: 'DT_PAGTO' },
      { title: "Situação", data: 'SITUACAO' },
      { title: "Desc. Situação", data: 'DESCSIT' },
      { title: "Valor", data: 'VALOR' },
      { title: "Valor Pago", data: 'VALOR_PAGO' },
      { title: "Banco", data: 'BANCO' },
      { title: "Nome Banco", data: 'NOME_BANCO' },
      { title: "Status", data: 'STATUS' },
    ];

    criaDataTablePadrao('#tabelaReceber', false, false, false, false, true, true, '300px', retornoSelect, dataSetCols, [10], [1, 2, 3], [], [6, 7], {}, 2, '', '', false, [], [6, 7]);
  }

  function insereItens(sDados) {
    const dataSetCols = [];

    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', sDados, dataSetCols, [], [], [], [], {}, 2, '', '', false, [], [4]);
  }

  async function retornaItens(sPedido) {
    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: ['PED_ITEN.CODIGO', 'PRODUTO.DESCRICAO', 'PED_ITEN.COR', 'PED_ITEN.TAM', 'PED_ITEN.QTDE'],
      leftJoin: [{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO' }],
      where: [`PED_ITEN.NUMERO = '${sPedido}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  }

  function insereItens(sDados) {
    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);

    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', sDados, dataSetCols, [], [], [], [], {}, 2, '', '', false, [], [4]);
  }

  function insereDadosTabela(sDados) {
    const dataSetCols = [
      {
        title: "Selecionar",
        data: "SEL",
        render: function (data, type, row, meta) {
          return `<div class="icheck-primary d-inline">
                  <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
                </div>`;
        },
      },
      { title: "Número", data: "NUMERO" },
      { title: "Codcli", data: "CODCLI" },
      {
        title: "Nome",
        data: "NOME",
        render: function (data, type, row, meta) {
          return `<div 
                    data-id="${row.id}" 
                    title="Análise Financeira" 
                    style="cursor: pointer;">
                  <label class="mt-0">${data}</label>
                  <i class="nav-icon fas fa-clipboard-check ml-2 icon-blue btn-analise"></i>
                </div>`;
        }
      },
      { title: "Qtde Pendente", data: "QTDE_PEND" },
      { title: "Valor Pendente", data: "VALOR_PEND" },
      { title: "Qtde Faturado", data: "QTDE_FAT" },
      { title: "Valor Faturado", data: "VALOR_FAT" },
      { title: "Qtde Cancelado", data: "QTDE_CANC" },
      { title: "Valor Cancelado", data: "VALOR_CANC" },
      { title: "<span style='color: var(--textDesconto);'>Qtde Total</span>", data: "QTDE_TOT" },
      { title: "<span style='color: var(--textDesconto);'>Valor Total</span>", data: "VALOR_TOT" }
    ];

    $('#tabelaPedido').DataTable({
      bPaginate: true,
      search: false,
      destroy: true,
      colReorder: true,
      order: [],
      info: false,
      filter: false,
      scrollY: '300px',
      scrollX: true,
      autoWidth: true,
      columns: dataSetCols,
      data: sDados,
      columnDefs: [
        {
          render: function (data) {
            if (data && !isNaN(data)) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            }
            return '';
          },
          targets: [4, 5, 6, 7, 8, 9, 10, 11],
        },
        {
          targets: [4, 5, 6, 7, 8, 9, 10, 11],
          className: 'pr-4 text-right'
        }
      ],
      createdRow: function (row, data, dataIndex) {
        $('td', row).eq(10).css({ 'color': 'var(--textDesconto)', 'font-weight': 'bold' });
        $('td', row).eq(11).css({ 'color': 'var(--textDesconto)', 'font-weight': 'bold' });
      }
    });

    $('#tabelaPedido_length').prepend('<button class="buttonColVis" id="buttonColVisPedido"><i class="fas fa-cogs"></i></button>');
    $('#tabelaPedido_length').prepend('<button class="buttonExcel" id="buttonExcelPedido"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisPedido').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelPedido').prop('title', 'Exportar')

    $('#buttonColVisPedido').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelPedido').on('click', async function () {
      let dados = $("#tabelaPedido").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Liberacao Financeira - Pedidos', '#tabelaPedido', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaPedido').DataTable().columns(colunas.liberacaoFinanceiraPedidos ?? []).visible(false);
    $('#tabelaPedido').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.liberacaoFinanceiraPedidos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $(document).off("click", ".campoSel").on("click", ".campoSel", function () {
      $(this).toggleClass("selecionado", this.checked);
    });
  }

  function retornaFiltro() {
    let where = ' 1 = 1 ';
    where += $('#txtDtFaturaDe').val() != '' ? ` AND PEDIDO.DT_FATURA >= '${$('#txtDtFaturaDe').val()}' ` : '';
    where += $('#txtDtFaturaAte').val() != '' ? ` AND PEDIDO.DT_FATURA <= '${$('#txtDtFaturaAte').val()}' ` : '';
    where += $('#txtDtEmissaoDe').val() != '' ? ` AND PEDIDO.DT_EMISSAO >= '${$('#txtDtEmissaoDe').val()}' ` : '';
    where += $('#txtDtEmissaoAte').val() != '' ? ` AND PEDIDO.DT_EMISSAO <= '${$('#txtDtEmissaoAte').val()}' ` : '';
    where += $('#txtDtSaidaDe').val() != '' ? ` AND PEDIDO.DT_SAIDA >= '${$('#txtDtSaidaDe').val()}' ` : '';
    where += $('#txtDtSaidaAte').val() != '' ? ` AND PEDIDO.DT_SAIDA <= '${$('#txtDtSaidaAte').val()}' ` : '';
    where += $('#txtPeriodoEntDe').val() != '' ? ` AND PEDIDO.PERIODO >= '${pegaChave('#txtPeriodoEntDe')}' ` : '';
    where += $('#txtPeriodoEntAte').val() != '' ? ` AND PEDIDO.PERIODO <= '${pegaChave('#txtPeriodoEntAte')}' ` : '';
    where += $('#txtListaPedidos').val() != '' ? ` AND PEDIDO.NUMERO IN (${$('#txtListaPedidos').val()}) ` : '';
    where += $('#txtCliente').val() != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtCliente')}' ` : '';
    where += $('#txtRepresentante').val() != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentante')}' ` : '';
    where += $('#txtColecao').val() != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecao')}' ` : '';
    where += $('#radioBloqVendas').prop('checked') ? ` AND PEDIDO.BLOQUEIO = '0' ` : '';
    where += $('#radioBloqFinan').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '0' ` : '';
    where += $('#radioBloqFinanLibVend').prop('checked') ? ` AND (PEDIDO.BLOQUEIO = '1' AND PEDIDO.FINANCEIRO = '0') ` : '';
    where += $('#radioBloqExp').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '2' ` : '';
    where += ` AND PEDIDO.EMP_ID = '${getCookie('emp_id')}' `;
    return where;
  }

  function retornaGroupBy() {
    let groupBy = 'PEDIDO.NUMERO, ENTIDADE.NOME, ENTIDADE.CODCLI'

    return groupBy
  }

  $('#tabelaPedido').on('click', '.btn-analise', async function () {
    const rowData = $('#tabelaPedido').DataTable().row($(this).closest('tr')).data();

    const tabAnaliseFinanceira = window.parent.document.querySelector('.content-wrapper.iframe-mode').querySelector('.tab-content').querySelector('#panel--sisplan_web-analisefinanceira')

    if (tabAnaliseFinanceira == null) {
      localStorage.setItem('clientesanalisefinanceira', `[${rowData.CODCLI}] - ${rowData.NOME}`)
      parent.document.querySelector('#menu_relatorio_analisefinanceira .nav-link').click();
    } else {
      await msgAlerta('Tela já aberta, verifique.');
    }
  });

  $('.liberarBloq').on('change', function () {
    if ($(this)[0].id == 'radioBloquear') {
      $('#divMotivo').removeClass('d-none')
    } else {
      $('#divMotivo').addClass('d-none')
    }
  })

  function addPesquisaAutocompleta() {
    $('#txtPedido').on('blur', function () {
      let pedido = $('#txtPedido').val();
      if (pedido.includes("[")) {
        pedido = pegaChave($('#txtPedido'));
      } else {
        pedido = $('#txtPedido').val();
      }
      pedido = pedido.replace('\w', '');

      const listaPedidos = $('#txtListaPedidos').val();
      if (pedido == '') {
        return;
      }
      $('#txtListaPedidos').val((listaPedidos == '') ? `'${pedido}'` : `${listaPedidos},'${pedido}'`);
      $('#txtPedido').val('');
      $('#txtPedido').focus();
    });
    $('#txtPedido').on('keydown', async function (event) {
      if (event.key == 'Enter') {
        $('#txtPedido').trigger('blur');
        $('#txtPedido').focus();
      }
    });
    $('#btn-limpa-Pedido').on('click', function () { $('#txtListaPedidos').val(''); });
    $("#btn-PedidoConsulta").pesquisa_serverside(["#txtPedido"], ["NUMERO"], ["CODCLI"], `{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI" ]}`, "Pesquisa Pedido");

    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
    $('#btn-Cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Cliente");
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').val(''); });

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`,);
    $('#btn-Representante').pesquisa_array(['#txtRepresentante'], ['CODREP'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome" ], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`, "Pesquisa Represen", "represen");
    $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').val(''); });

    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Colecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Coleção', 'colecao');
    $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').val('') });

    $('#txtPeriodoEntDe').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntDe').pesquisa('#txtPeriodoEntDe', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntDe').on('click', function () {
      $('#txtPeriodoEntDe').val('');
    });

    $('#txtPeriodoEntAte').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntAte').pesquisa('#txtPeriodoEntAte', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntAte').on('click', function () {
      $('#txtPeriodoEntAte').val('');
    });
  }
});