<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Itens de Estoque de Materiais</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2510.2.1">

    <!-- Theme style -->
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2510.2.1">
    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2510.2.1">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2510.2.1">
    <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.2510.2.1">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2510.2.1">
    <!-- Toastr -->
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2510.2.1">
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2510.2.1">
    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2510.2.1" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2510.2.1">
    <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.2510.2.1">
    <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2510.2.1">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="../plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.2510.2.1">


</head>
<style>
    #msform {
        text-align: start;
        position: relative;
    }

    .card {
        box-shadow: none !important;
        border-radius: 0 !important;
        margin-bottom: 0 !important;
    }

    .card-header {
        box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card-body {
        margin-left: 0px !important;
        padding-left: 1.25rem !important;
        padding-top: 0px;
        padding-bottom: 1.25rem;
        padding-right: 1.25rem !important;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
        font-size: 20px;
        line-height: normal;
        font-weight: 500;
        color: #343a40;
        margin: 0;
        font-family: Roboto, Arial, sans-serif;
    }

    .form-group {
        margin-bottom: 0.2rem;
    }

    .border-Field {
        border: 1px groove #ddd !important;
        padding: 0 1.4em 0.5em 1.4em !important;
        -webkit-box-shadow: 0px 0px 0px 0px #000;
        box-shadow: 0px 0px 0px 0px #000;
        border-radius: 8px;
    }

    .border-Field .textoBorda {
        font-size: 1.2em !important;
        text-align: left !important;
        width: auto;
        padding: 0 10px;
        border-bottom: none;
    }

    .marginTop {
        margin-top: 8px;
    }

    .table.dataTable tbody td {
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
    }

    .table.dataTable thead th {
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
    }

    .bordaProduto {
        padding: 7px;
        border: solid #e0e4e6;
        border-radius: 4px;
        border-width: 2px;
        margin-top: 5px;
    }

    .label-tamanho {
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        text-align: center;
    }

    .content-wrapper {
        margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar {
        display: none;
    }

    .editableDiv {
        width: 120px;
        box-sizing: border-box;
        padding: 4px 6px;
        height: 28px;
        line-height: 20px;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
        border-radius: 3px;
        border: 1px solid transparent;
        background: transparent;
        cursor: text;
    }

    .editableDiv:focus {
        outline: none;
        border-color: #c2121a !important;
    }

</style>


<body class="hold-transition sidebar-mini layout-fixed">
    <main class="wrapper">

        <?php
        include_once('../../menu.php');
        ?>

        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h3 class="col-mb=2">Itens de Estoque de Produto</h3>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="card" style="height:auto;">
                                <div class="card-header">
                                    <div class="row col-12 pl-0">
                                        <h1 id="titleProduto" class="pl-0 ml-0"></h1>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-auto mt-2 pl-0">
                                            <fieldset class="form border-Field p-0 d-block d-md-flex">
                                                <legend class="textoBorda pb-0 mb-0">Opções</legend>
                                                <div class="icheck-primary mr-2">
                                                    <input type="checkbox" id="checkSomenteCEstoque" checked name="somenteCEstoque" />
                                                    <label for="checkSomenteCEstoque">
                                                        Somente com Estoque
                                                    </label>
                                                </div>
                                            </fieldset>
                                        </div>
                                        <div class="col-lg-3 col-3 pl-0" id="DepositoTour">
                                            <label data-error="wrong" data-success="right" for="txtDeposito">Depósito: </label>
                                            <div class="input-group">
                                                <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple"> </select>
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btnDeposito" name="btnDeposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <button class="btn bg-danger" id="btnLimpaDeposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-3" id="CorTour">
                                            <label data-error="wrong" data-success="right" for="txtCor">Cor: </label>
                                            <div class="input-group">
                                                <select class="js-example-programmatic js-states form-control" id="txtCor" name="txtCor" multiple="multiple"> </select>
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btnCor" name="btnCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <button class="btn bg-danger" id="btnLimpaCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-3" id="TamanhoTour">
                                            <label data-error="wrong" data-success="right" for="txtTamanho">Tamanho: </label>
                                            <div class="input-group">
                                                <select class="js-example-programmatic js-states form-control" id="txtTamanho" name="txtTamanho" multiple="multiple"> </select>
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btnTamanho" name="btnTamanho" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <button class="btn bg-danger" id="btnLimpaTamanho" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="d-flex align-items-center">
                                            <button type="button" id="btnConsultar" class="btn btn-primary btn-sisp">Consultar</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <fieldset>
                                <div class="card-body" style="padding-left: 0rem!important; padding-right: 0rem!important;">
                                    <form id="msform" name="msform">
                                        <div class="card card-body" style="padding-top: 10px;">
                                            <div class="row">
                                                <div class="col-sm-12 table-responsive table-selecttable-lg">
                                                    <table id="tabelaItensProd" class="table table-sm-sisp table-select table-hover" width="100%">
                                                        <thead>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 d-flex justify-content-end mt-3">
                                            <div class="col-4" style="flex-basis: fit-content;">
                                                <button type="button" id="btnVoltar" class="btn btn-secondary btn-sisp">Voltar</button>
                                                <button type="button" id="btnGravar" class="btn btn-primary btn-sisp">Gravar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <aside class="control-sidebar control-sidebar-dark">
        </aside>
        <?php
        include_once('../../modais.php');
        ?>
    </main>

    <script src="../plugins/jquery/jquery.min.js?versao=3.2510.2.1"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2510.2.1"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.2.1"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2510.2.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2510.2.1"></script>
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2510.2.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.2510.2.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.2.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.2510.2.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.2510.2.1"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.2510.2.1"></script>
    <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2510.2.1"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2510.2.1"></script>
    <script src="../dist/js/dataTables.keyTable.js?versao=3.2510.2.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.2510.2.1"></script>
    <script src="../utils/funcoes.js?versao=3.2510.2.1"></script>
    <script src="../utils/cookies.js?versao=3.2510.2.1"></script>
    <script src="../dist/js/driver.min.js?versao=3.2510.2.1"></script>
    <script src="../plugins/select2/js/select2.full.min.js?versao=3.2510.2.1"></script>
    <script type="text/javascript" src="../config.js?versao=3.2510.2.1"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-scrollTo/2.1.3/jquery.scrollTo.min.js"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            $('#btnVoltar').on('click', function(event) {
                event.preventDefault();
                window.history.back();
            });


            sArquivo = `${BASE_URI}/pages/proditensest/proditensest.js?versao=3.2510.2.1`;
            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

            const temAcesso = await temAcessoTela('PRODITENSEST');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            await insereJavaScriptPagina(sArquivo);

            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>