$(document).ready(async function () {

    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btnFiltrosRelPedidoRank',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimirRelPedidoRank',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para Imprimir um relatório.',
                    position: 'right'
                }
            },
            {
                element: '#buttonColVis',
                popover: {
                    title: 'Configurar colunas visíveis ',
                    description: 'Clique aqui para selecionar as colunas que deseja retirar da tabela.',
                    position: 'right'
                }
            },
            {
                element: '#buttonExcel',
                popover: {
                    title: 'Botão Exportar',
                    description: 'Clique aqui para exportar a tabela em CSV.',
                    position: 'right'
                }
            },
            ]);
            driver.start();
        });
    });

    componenteFiltro('tabPrazo', false, false, "PeriodoDeRelPedidoRank");
    componenteFiltro('tabPrazo', false, false, "PeriodoAteRelPedidoRank");
    componenteFiltro('empresaEmp_Pat', true, true, "EmpresaPedRelPedidoRank");
    componenteFiltro('produto', true, true, "ProdutoRelPedidoRank");
    componenteFiltro('cor', true, true, "CorProdRelPedidoRank");
    componenteFiltro('grupo', true, true, "GrupoProdRelPedidoRank");
    componenteFiltro('colecao', true, true, "ColecaoProdRelPedidoRank");
    componenteFiltro('linha', true, true, "LinhaProdRelPedidoRank");
    componenteFiltro('marca', true, true, "MarcaProdRelPedidoRank");
    componenteFiltro('etiqueta', true, true, "EtiquetaProdRelPedidoRank");
    componenteFiltro('categoriaProd', true, true, "CategoriaProdRelPedidoRank");
    componenteFiltro('entidade', true, true, "ClienteProdRelPedidoRank"); // CLIENTE PROD
    componenteFiltro('deposito', true, true, "DepositoRelPedidoRank");
    componenteFiltro('pedido', true, true, "PedidoRelPedidoRank");
    componenteFiltro('status', true, true, "StatusPedidoRelPedidoRank");
    componenteFiltro('tipo', true, true, "TipoVendaRelPedidoRank");
    componenteFiltro('grupoPed', true, true, "GrupoPedidoRelPedidoRank");
    componenteFiltro('colecao', true, true, "ColecaoPedidoRelPedidoRank");
    componenteFiltro('tipo', true, true, "TipoPedidoRelPedidoRank");
    componenteFiltro('entidade', true, true, "ClienteRelPedidoRank"); // CLIENTE
    componenteFiltro('grupoCli', true, true, "GrupoClienteRelPedidoRank");
    componenteFiltro('representante', true, true, "RepresentanteRelPedidoRank");
    componenteFiltro('tabPreco', true, true, "TabelaPrecoRelPedidoRank");
    componenteFiltro('cidade', true, true, "CidadeRelPedidoRank"); // VALIDAR ESSE CAMPO POIS ESTA RETORNANDO NOS CAMPOS SELECT O COD_UF COMO CHAVE
    componenteFiltro('tabuf', true, true, "EstadoRelPedidoRank");
    componenteFiltro('regEstado', true, true, "RegiaoRelPedidoRank");

    retornaHintRelatorio('btnImprimirRelPedidoRank', 'RelPedidoRank');

    let consultando = true
    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relPedidoRank == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPedidoRank: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    const ordenacoes = await retornaOrdenacaoRelatorio();
    let dadosTabelaCorTam = [];
    adicionaOrdenacoes(ordenacoes);

    $("#btnFiltrosRelPedidoRank").on("click", function () {
        $("#modalFiltrosRelPedidoRank").modal("show");
    })

    $("#btnConsultarRelPedidoRank").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            consultando = true
            const registros = await consultarRelPedidoRank();
            preencheTabelaRelPedidoRank(registros[0]);
            if (registros[1] && registros[1].length > 0) {
                dadosTabelaCorTam = registros[1];
                $($("#tabelaRankingRelPedidoRank tbody tr")[0]).trigger("click");
            } else {
                limpaTabela("#tabelaCorTamRelPedidoRank");
                dadosTabelaCorTam = [];
            }
            consultando = false
        } finally {
            $.LoadingOverlay("hide");
            $("#modalFiltrosRelPedidoRank").modal("hide");
        }
    })

    $("#btnLimparFiltroRelPedidoRank").on("click", function () {
        limparFiltros();
    })

    $("#btnImprimirRelPedidoRank").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            await imprimirRelPedidoRank();
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#btnSelecionarEmpresas").on("click", function () {
        carregaEmpresasDisponiveis();
    });

    $('#btnConfirmarColunas').on('click', async function () {
        $.LoadingOverlay('show');
        try {

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPedidoRank: novasColunas }))

            $('#tabelaRankingRelPedidoRank').DataTable().columns().visible(true);

            $('#tabelaRankingRelPedidoRank').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    async function consultarRelPedidoRank() {
        const url = `/sisplan/relpedidorank/v1/consultarelpedidorank?`;
        const params = await retornaFiltros();
        try {

            const response = await requisicao("GET", url, params, "", 360000);

            if (!response) {
                throw new Error("Não foi possível consultar o relatório de ranking de pedido.");
            }

            const json = await response.json();
            if (response.status != 200) {
                throw new Error(json.mensagem);
            }

            return json;

        } catch (error) {
            console.error("Ocorreu um erro na função consultaRelPedidoRank: " + error);
            msgAlerta(error.message);
        }
    }

    async function imprimirRelPedidoRank() {
        try {
            const url = "/sisplan/impressao/v1/relpedidorank?";
            const filtros = await retornaFiltros();
            const bImprimeAutomatico = await verificaImprimirAutomatico("RelPedidoRank");
            const arquivo = await GeraRelatorio(`${url}${filtros}`, "GET", 1000000, false, "RelPedidoRank");
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }
        } catch (error) {
            console.error(error);
        }

    }

    function preencheTabelaRelPedidoRank(registros) {
        let indiceTotal = [];

        limpaTabela("#tabelaRankingRelPedidoRank");

        if (registros.length > 0) {

            let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
            ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)
            const dataSetCols = [];
            let keys

            if (ordemColunasRelatorio != null && ordemColunasRelatorio.relPedidoRank != undefined) {
                const nome = $('#selectOrdenacao').val().indexOf('NOME_ORD_TELA":"')
                const fimNome = $('#selectOrdenacao').val().substring(nome, nome + $('#selectOrdenacao').val().length)
                const ordenacao = fimNome.substring(16, fimNome.length - 2)
                const colunas = ordemColunasRelatorio.relPedidoRank.filter(f => f.ordenacao == ordenacao)
                keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(registros[0]);   
            } else{
                keys = Object.keys(registros[0]);
            }
            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
                if (keys[k] == "TOTAL") {
                    indiceTotal.push(+k)
                }
            };

            criaDataTablePadrao('#tabelaRankingRelPedidoRank',
                true,
                false,
                false,
                false,
                true,
                true,
                "300px",
                registros,
                dataSetCols,
                [],
                [],
                [],
                indiceTotal,
                {},
                2,
                "buttonColVis",
                "buttonExcel",
                true,
                [],
                [],
                true);

            const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            $("#tabelaRankingRelPedidoRank").DataTable().page.len(100).draw(false);

            // $('#tabelaRankingRelPedidoRank_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            // $('#tabelaRankingRelPedidoRank_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            // $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
            // $('#buttonExcel').prop('title', 'Exportar');

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                try {
                    $('#modal-ColunasVisiveis').modal('show');
                } finally {
                    $.LoadingOverlay('hide');
                }
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaRankingRelPedidoRank").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório de Ranking de Faccao - Tabela Ranking', '#tabelaRankingRelPedidoRank', '', 999, false, false, dados);
            })

            $('#tabelaRelPedidos').DataTable().columns().every(
                function () {
                    if ((colunasInvisiveis.relPedidos).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

            $("#tabelaRankingRelPedidoRank tbody").on("click", "tr", function () {
                if ($(this).hasClass("selected")) {
                    $(this).removeClass("selected");
                    limpaTabela("#tabelaCorTamRelPedidoRank");
                } else {
                    $('#tabelaRankingRelPedidoRank').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass("selected");
                    const registroSelecionado = $("#tabelaRankingRelPedidoRank").DataTable().rows($(this).closest('tr')).data().toArray()[0];
                    const registros = retornaDadosFiltradosTabelaCorTam(registroSelecionado.PRODUTO);
                    preencheTabelaCorTam(registros);
                }
            })

            $('#tabelaRankingRelPedidoRank').on('column-reorder.dt', function (e, settings, details) {
                if (consultando) {
                    return
                }
                const newColumnOrder = []

                for (let i = 0; i < settings.aoColumns.length; i++) {
                    const column = settings.aoColumns[i].mData

                    newColumnOrder.push(column)
                }

                let ordemColunas = localStorage.getItem('ordemColunasDataTable')
                ordemColunas = JSON.parse(ordemColunas)
                const res = $('#selectOrdenacao').val().indexOf('NOME_ORD_TELA":"')
                const fim = $('#selectOrdenacao').val().substring(res, res + $('#selectOrdenacao').val().length)
                const ordenacao = fim.substring(16, fim.length - 2)

                if (ordemColunas == null || ordemColunas.relPedidoRank == undefined) {
                    localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, relPedidoRank: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

                } else if (!ordemColunas.relPedidoRank.some(s => s.ordenacao.includes(ordenacao))) {

                    const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
                    const newObj = {ordenacao: ordenacao, colunas: newColumnOrder}
                    ordensSalvas.relPedidoRank.push(newObj)
                    localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

                } else if (ordemColunas.relPedidoRank.some(s => s.ordenacao.includes(ordenacao))) {
                    
                    const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
                    ordensSalvas.relPedidoRank.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
                    localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
                }
            });

        }
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaRankingRelPedidoRank').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relPedidos ?? [])
    })

    function preencheTabelaCorTam(registros) {
        let indiceValor = [];

        limpaTabela("#tabelaCorTamRelPedidoRank");

        if (registros && registros.length > 0) {
            $("#labelTabelaCorTamRelPedidoRank").removeClass("d-none");

            const dataSetCols = [];
            const keys = Object.keys(registros[0]);
            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
                if (keys[k] == "VALOR") {
                    indiceValor.push(+k);
                }
            };

            criaDataTablePadrao('#tabelaCorTamRelPedidoRank',
                false,
                false,
                false,
                false,
                true,
                true,
                false,
                registros,
                dataSetCols,
                [],
                [],
                [],
                indiceValor,
                {},
                2,
                "buttonColVisFaccao",
                "buttonExcelFaccao",
                []);

        } else {
            $("#labelTabelaCorTamRelPedidoRank").addClass("d-none");
        }
    }

    async function retornaFiltros() {
        const tipoPedido = $($('input[name="tipoPedido"]:checked')).val();
        const radioStatusPedido = $("#txtStatusPedido").val();
        const liberacaoPedido = $("#txtLiberacaoPedido").val();
        const dataEmissaoPedidoI = $("#txtDataEmissaoPedidoI").val();
        const dataEmissaoPedidoF = $("#txtDataEmissaoPedidoF").val();
        const dataFaturaPedidoI = $("#txtDataFaturaPedidoI").val();
        const dataFaturaPedidoF = $("#txtDataFaturaPedidoF").val();
        const dataEntragaPedidoI = $("#txtDataEntregaPedidoI").val();
        const dataEntragaPedidoF = $("#txtDataEntregaPedidoF").val();
        const periodoDe = pegaChave("#txtPeriodoDeRelPedidoRank");
        const periodoAte = pegaChave("#txtPeriodoAteRelPedidoRank");
        const empresaPed = await formataListas($('#txtEmpresaPedRelPedidoRank').val().toString());
        const produto = await formataListas($('#txtProdutoRelPedidoRank').val().toString());
        const corProduto = await formataListas($('#txtCorProdRelPedidoRank').val().toString());
        const grupoProduto = await formataListas($('#txtGrupoProdRelPedidoRank').val().toString());
        const colecaoProduto = await formataListas($('#txtColecaoProdRelPedidoRank').val().toString());
        const linhaProduto = await formataListas($('#txtLinhaProdRelPedidoRank').val().toString());
        const marcaProduto = await formataListas($('#txtMarcaProdRelPedidoRank').val().toString());
        const etiquetaProduto = await formataListas($('#txtEtiquetaProdRelPedidoRank').val().toString());
        const categoriaProduto = await formataListas($('#txtCategoriaProdRelPedidoRank').val().toString());
        const consideraClienteProduto = $("#cbConsideraClienteProd").prop("checked");
        const clienteProduto = await formataListas($('#txtClienteProdRelPedidoRank').val().toString());
        const deposito = await formataListas($('#txtDepositoRelPedidoRank').val().toString());
        const pedido = await formataListas($('#txtPedidoRelPedidoRank').val().toString());
        const consideraStatusPedido = $("#cbConsideraStatusPedido").prop("checked");
        const statusPedido = await formataListas($('#txtStatusPedidoRelPedidoRank').val().toString());
        const tipoVenda = await formataListas($('#txtTipoVendaRelPedidoRank').val().toString());
        const grupoPedido = await formataListas($('#txtGrupoPedidoRelPedidoRank').val().toString());
        const colecaoPedido = await formataListas($('#txtColecaoPedidoRelPedidoRank').val().toString());
        const tipoVendaPedido = await formataListas($('#txtTipoPedidoRelPedidoRank').val().toString());
        const consideraCliente = $("#cbConsideraCliente").prop("checked");
        const cliente = await formataListas($('#txtClienteRelPedidoRank').val().toString());
        const consideraGrupoCliente = $("#cbConsideraGrupoCliente").prop("checked");
        const grupoCliente = await formataListas($('#txtGrupoClienteRelPedidoRank').val().toString());
        const consideraReprensentante = $("#cbConsideraRepresentante").prop("checked");
        const representante = await formataListas($('#txtRepresentanteRelPedidoRank').val().toString());
        const tabelaPreco = await formataListas($('#txtTabelaPrecoRelPedidoRank').val().toString());
        const cidade = await formataListas($('#txtCidadeRelPedidoRank').val().toString());
        const estado = await formataListas($('#txtEstadoRelPedidoRank').val().toString());
        const regiao = await formataListas($('#txtRegiaoRelPedidoRank').val().toString());
        const ordenacaoRelatorio = $("#selectOrdenacao").val();
        const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];

        const params = `TIPO_PEDIDO=${tipoPedido}` +
            `&RADIO_STATUS_PEDIDO=${radioStatusPedido}` +
            `&LIBERACAO_PEDIDO=${liberacaoPedido}` +
            `&DATA_EMISSAO_I=${dataEmissaoPedidoI}` +
            `&DATA_EMISSAO_F=${dataEmissaoPedidoF}` +
            `&DATA_FATURA_I=${dataFaturaPedidoI}` +
            `&DATA_FATURA_F=${dataFaturaPedidoF}` +
            `&DATA_ENTREGA_I=${dataEntragaPedidoI}` +
            `&DATA_ENTREGA_F=${dataEntragaPedidoF}` +
            `&PERIODO_DE=${periodoDe}` +
            `&PERIODO_ATE=${periodoAte}` +
            `&EMPRESA_PED=${empresaPed}` +
            `&PRODUTO=${produto}` +
            `&COR_PRODUTO=${corProduto}` +
            `&GRUPO_PRODUTO=${grupoProduto}` +
            `&COLECAO_PRODUTO=${colecaoProduto}` +
            `&TPVENDA_PEDIDO=${tipoVendaPedido}` +
            `&LINHA_PRODUTO=${linhaProduto}` +
            `&MARCA_PRODUTO=${marcaProduto}` +
            `&ETIQUETA_PRODUTO=${etiquetaProduto}` +
            `&CATEGORIA_PRODUTO=${categoriaProduto}` +
            `&CONSIDERA_CLIENTE_PRODUTO=${consideraClienteProduto}` +
            `&CLIENTE_PRODUTO=${clienteProduto}` +
            `&DEPOSITO=${deposito}` +
            `&PEDIDO=${pedido}` +
            `&CONSIDERA_STATUS_PEDIDO=${consideraStatusPedido}` +
            `&STATUS_PEDIDO=${statusPedido}` +
            `&TIPO_VENDA=${tipoVenda}` +
            `&GRUPO_PEDIDO=${grupoPedido}` +
            `&COLECAO_PEDIDO=${colecaoPedido}` +
            `&CONSIDERA_CLIENTE=${consideraCliente}` +
            `&CLIENTE=${cliente}` +
            `&CONSIDERA_GRUPO_CLIENTE=${consideraGrupoCliente}` +
            `&GRUPO_CLIENTE=${grupoCliente}` +
            `&CONSIDERA_REPRESENTANTE=${consideraReprensentante}` +
            `&REPRESENTANTE=${representante}` +
            `&TABELA_PRECO=${tabelaPreco}` +
            `&CIDADE=${cidade}` +
            `&ESTADO=${estado}` +
            `&REGIAO=${regiao}` +
            `&ORDENACAO_RELATORIO=${ordenacaoRelatorio}` +
            `&EMP_ID=${listaEmpIds}`;

        return params;

    }

    async function retornaOrdenacaoRelatorio() {
        const url = `/sisplan/ordemrelatorio/v1/retornaordenacaorelatorio?`;
        const params = "NOME_TELA=RelPedidoRank";
        try {

            const response = await requisicao("GET", url, params, "", 360000);

            if (!response) {
                throw new Error("Não foi possível consultar as ordens do relatório.");
            }

            const json = await response.json();
            if (response.status != 200) {
                throw new Error(json.mensagem);
            }

            return json;

        } catch (error) {
            console.error("Ocorreu um erro na função adicionaOrdem. Erro: " + error);
        }

    }

    function adicionaOrdenacoes(listaOrdenacoes) {
        listaOrdenacoes?.forEach((ordenacao) => {
            const option = {
                id: JSON.stringify(ordenacao),
                text: ordenacao.NOME_ORD_TELA
            }
            const newOption = new Option(option.text, option.id, true, true);
            $("#selectOrdenacao").append(newOption).trigger('change');
        });
        $('.btnEdicaoRelatorio').attr('nome_tela', 'RelPedidoRank');
    }

    function limpaTabela(tabela) {
        if ($.fn.DataTable.isDataTable(tabela)) {
            $(tabela).DataTable().destroy().draw(false);
            $(tabela).html("<thead></thead><tbody></tbody>");
        }
    }

    function retornaDadosFiltradosTabelaCorTam(produto) {
        return dadosTabelaCorTam.filter(registro => registro.PRODUTO == produto);
    }
});